/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.rest;

import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.util.HttpResponses;
import java.io.IOException;
import jenkins.metrics.api.Metrics;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;
import org.jenkinsci.plugins.prometheus.service.DefaultPrometheusMetrics;
import org.jenkinsci.plugins.prometheus.service.PrometheusMetrics;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

@Extension
public class PrometheusAction
implements UnprotectedRootAction {
    private final PrometheusMetrics prometheusMetrics = DefaultPrometheusMetrics.get();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Prometheus Metrics Exporter";
    }

    public String getUrlName() {
        return PrometheusConfiguration.get().getUrlName();
    }

    public HttpResponse doDynamic(StaplerRequest2 request) {
        if (request.getRestOfPath().equals(PrometheusConfiguration.get().getAdditionalPath())) {
            if (this.hasAccess()) {
                return this.prometheusResponse();
            }
            return HttpResponses.forbidden();
        }
        return HttpResponses.notFound();
    }

    private boolean hasAccess() {
        if (PrometheusConfiguration.get().isUseAuthenticatedEndpoint()) {
            return Jenkins.get().hasPermission(Metrics.VIEW);
        }
        return true;
    }

    private HttpResponse prometheusResponse() {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest2 request, StaplerResponse2 response, Object node) throws IOException {
                response.setStatus(200);
                response.setContentType("text/plain; version=0.0.4; charset=utf-8");
                response.addHeader("Cache-Control", "must-revalidate,no-cache,no-store");
                response.getWriter().write(PrometheusAction.this.prometheusMetrics.getMetrics());
            }
        };
    }
}

