/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.jenkins;

import hudson.model.Computer;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import java.time.Clock;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.prometheus.collectors.BaseMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;

public class JenkinsUptimeGauge
extends BaseMetricCollector<Jenkins, Gauge> {
    JenkinsUptimeGauge(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.JENKINS_UPTIME_GAUGE;
    }

    @Override
    protected String getHelpText() {
        return "Time since Jenkins machine was initialized";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    @Override
    public void calculateMetric(Jenkins jenkinsObject, String[] labelValues) {
        if (jenkinsObject == null) {
            return;
        }
        Computer computer = jenkinsObject.toComputer();
        if (computer == null) {
            return;
        }
        long upTime = computer.getConnectTime();
        ((Gauge)this.collector).set((double)(Clock.systemUTC().millis() - upTime));
    }
}

