/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.disk;

import com.cloudbees.simplediskusage.JobDiskItem;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import org.jenkinsci.plugins.prometheus.collectors.BaseMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;

public class JobUsageBytesGauge
extends BaseMetricCollector<JobDiskItem, Gauge> {
    protected JobUsageBytesGauge(String[] labelNames, String namespace, String subsystem) {
        super(labelNames, namespace, subsystem);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.JOB_USAGE_BYTES_GAUGE;
    }

    @Override
    protected String getHelpText() {
        return "Amount of disk usage (bytes) for each job in Jenkins";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    @Override
    public void calculateMetric(JobDiskItem jenkinsObject, String[] labelValues) {
        if (jenkinsObject == null) {
            return;
        }
        Long usage = jenkinsObject.getUsage();
        if (usage == null) {
            return;
        }
        ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set((double)(usage * 1024L));
    }
}

