/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.jenkins;

import io.prometheus.client.Collector;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.prometheus.collectors.BaseCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.NoOpMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.jenkins.JenkinsQuietDownGauge;
import org.jenkinsci.plugins.prometheus.collectors.jenkins.JenkinsUpGauge;
import org.jenkinsci.plugins.prometheus.collectors.jenkins.JenkinsUptimeGauge;
import org.jenkinsci.plugins.prometheus.collectors.jenkins.JenkinsVersionInfo;
import org.jenkinsci.plugins.prometheus.collectors.jenkins.NodesOnlineGauge;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;

public class JenkinsCollectorFactory
extends BaseCollectorFactory {
    public MetricCollector<Jenkins, ? extends Collector> createCollector(CollectorType type, String[] labelNames) {
        switch (type) {
            case JENKINS_UP_GAUGE: {
                return this.saveBuildCollector(new JenkinsUpGauge(labelNames, this.namespace, this.subsystem));
            }
            case JENKINS_QUIETDOWN_GAUGE: {
                return this.saveBuildCollector(new JenkinsQuietDownGauge(labelNames, this.namespace, this.subsystem));
            }
            case NODES_ONLINE_GAUGE: {
                if (!this.isNodeOnlineGaugeEnabled()) {
                    return new NoOpMetricCollector();
                }
                return this.saveBuildCollector(new NodesOnlineGauge(labelNames, this.namespace, this.subsystem));
            }
            case JENKINS_UPTIME_GAUGE: {
                return this.saveBuildCollector(new JenkinsUptimeGauge(labelNames, this.namespace, this.subsystem));
            }
            case JENKINS_VERSION_INFO_GAUGE: {
                return this.saveBuildCollector(new JenkinsVersionInfo(labelNames, this.namespace, this.subsystem));
            }
        }
        return new NoOpMetricCollector();
    }

    private boolean isNodeOnlineGaugeEnabled() {
        return PrometheusConfiguration.get().isCollectNodeStatus();
    }
}

