/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus;

import hudson.model.Job;
import hudson.model.Run;
import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.jenkinsci.plugins.prometheus.collectors.CollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildCompletionListener;
import org.jenkinsci.plugins.prometheus.collectors.builds.CounterManager;
import org.jenkinsci.plugins.prometheus.collectors.builds.JobLabel;
import org.jenkinsci.plugins.prometheus.config.PrometheusConfiguration;
import org.jenkinsci.plugins.prometheus.config.disabledmetrics.MetricStatusChecker;
import org.jenkinsci.plugins.prometheus.util.Jobs;
import org.jenkinsci.plugins.prometheus.util.Runs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobCollector
extends Collector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobCollector.class);
    private final BuildMetrics lastBuildMetrics = new BuildMetrics("last");
    private final BuildMetrics perBuildMetrics = new BuildMetrics("");
    private MetricCollector<Run<?, ?>, ? extends Collector> summary;
    private MetricCollector<Job<?, ?>, ? extends Collector> jobHealthScoreGauge;
    private MetricCollector<Job<?, ?>, ? extends Collector> nbBuildsGauge;
    private MetricCollector<Job<?, ?>, ? extends Collector> buildDiscardGauge;
    private MetricCollector<Job<?, ?>, ? extends Collector> currentRunDurationGauge;
    private MetricCollector<Job<?, ?>, ? extends Collector> logUpdatedGauge;

    public List<Collector.MetricFamilySamples> collect() {
        LOGGER.debug("Collecting metrics for prometheus");
        CollectorFactory factory = new CollectorFactory();
        ArrayList<Collector.MetricFamilySamples> samples = new ArrayList<Collector.MetricFamilySamples>();
        String[] labelBaseNameArray = JobLabel.getBaseLabelNames();
        String[] labelNameArray = JobLabel.getJobLabelNames();
        boolean processDisabledJobs = PrometheusConfiguration.get().isProcessingDisabledBuilds();
        boolean ignoreBuildMetrics = !PrometheusConfiguration.get().isCountAbortedBuilds() && !PrometheusConfiguration.get().isCountFailedBuilds() && !PrometheusConfiguration.get().isCountNotBuiltBuilds() && !PrometheusConfiguration.get().isCountSuccessfulBuilds() && !PrometheusConfiguration.get().isCountUnstableBuilds();
        BuildCompletionListener listener = BuildCompletionListener.getInstance();
        if (ignoreBuildMetrics) {
            listener.unregister();
            return samples;
        }
        this.summary = factory.createRunCollector(CollectorType.BUILD_DURATION_SUMMARY, labelNameArray, null);
        CounterManager manager = CounterManager.getManager();
        MetricCollector<Run<?, ?>, Collector> jobSuccessCount = manager.getCounter(CollectorType.BUILD_SUCCESSFUL_COUNTER, labelBaseNameArray, null);
        MetricCollector<Run<?, ?>, Collector> jobFailedCount = manager.getCounter(CollectorType.BUILD_FAILED_COUNTER, labelBaseNameArray, null);
        MetricCollector<Run<?, ?>, Collector> jobTotalCount = manager.getCounter(CollectorType.BUILD_TOTAL_COUNTER, labelBaseNameArray, null);
        MetricCollector<Run<?, ?>, Collector> jobAbortedCount = manager.getCounter(CollectorType.BUILD_ABORTED_COUNTER, labelBaseNameArray, null);
        MetricCollector<Run<?, ?>, Collector> jobUnstableCount = manager.getCounter(CollectorType.BUILD_UNSTABLE_COUNTER, labelBaseNameArray, null);
        try (BuildCompletionListener.CloseableIterator<Run<?, ?>> iterator = listener.iterator();){
            while (iterator.hasNext()) {
                Run run = (Run)iterator.next();
                Job job2 = run.getParent();
                String[] labelValues = JobLabel.getBaseLabelValues(job2);
                jobFailedCount.calculateMetric(run, labelValues);
                jobSuccessCount.calculateMetric(run, labelValues);
                jobTotalCount.calculateMetric(run, labelValues);
                jobAbortedCount.calculateMetric(run, labelValues);
                jobUnstableCount.calculateMetric(run, labelValues);
            }
        }
        this.jobHealthScoreGauge = factory.createJobCollector(CollectorType.HEALTH_SCORE_GAUGE, labelBaseNameArray);
        this.nbBuildsGauge = factory.createJobCollector(CollectorType.NB_BUILDS_GAUGE, labelBaseNameArray);
        this.buildDiscardGauge = factory.createJobCollector(CollectorType.BUILD_DISCARD_GAUGE, labelBaseNameArray);
        this.currentRunDurationGauge = factory.createJobCollector(CollectorType.CURRENT_RUN_DURATION_GAUGE, labelBaseNameArray);
        this.logUpdatedGauge = factory.createJobCollector(CollectorType.JOB_LOG_UPDATED_GAUGE, labelBaseNameArray);
        if (PrometheusConfiguration.get().isPerBuildMetrics()) {
            labelNameArray = Arrays.copyOf(labelNameArray, labelNameArray.length + 1);
            labelNameArray[labelNameArray.length - 1] = "number";
            this.perBuildMetrics.initCollectors(labelNameArray);
        }
        this.lastBuildMetrics.initCollectors(labelBaseNameArray);
        Jobs.forEachJob(job -> {
            try {
                if (job.isBuildable()) {
                    if (!MetricStatusChecker.isJobEnabled(job.getFullName())) {
                        LOGGER.debug("Job [{}] is excluded by configuration", (Object)job.getFullName());
                        return;
                    }
                    LOGGER.debug("Collecting metrics for job [{}]", (Object)job.getFullName());
                    this.appendJobMetrics((Job<?, ?>)job);
                } else if (processDisabledJobs) {
                    this.appendJobMetrics((Job<?, ?>)job);
                } else {
                    LOGGER.debug("job [{}] is disabled", (Object)job.getFullName());
                }
            }
            catch (IllegalArgumentException e) {
                if (!e.getMessage().contains("Incorrect number of labels")) {
                    LOGGER.warn("Caught error when processing job [{}] error: ", (Object)job.getFullName(), (Object)e);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Caught error when processing job [{}] error: ", (Object)job.getFullName(), (Object)e);
            }
        });
        this.addSamples(samples, this.summary.collect(), "Adding [{}] samples from summary ({})");
        this.addSamples(samples, jobSuccessCount.collect(), "Adding [{}] samples from counter ({})");
        this.addSamples(samples, jobFailedCount.collect(), "Adding [{}] samples from counter ({})");
        this.addSamples(samples, jobAbortedCount.collect(), "Adding [{}] samples from counter ({})");
        this.addSamples(samples, jobUnstableCount.collect(), "Adding [{}] samples from counter ({})");
        this.addSamples(samples, jobTotalCount.collect(), "Adding [{}] samples from counter ({})");
        this.addSamples(samples, this.jobHealthScoreGauge.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(samples, this.nbBuildsGauge.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(samples, this.buildDiscardGauge.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(samples, this.currentRunDurationGauge.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(samples, this.logUpdatedGauge.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(samples, this.lastBuildMetrics);
        if (PrometheusConfiguration.get().isPerBuildMetrics()) {
            this.addSamples(samples, this.perBuildMetrics);
        }
        return samples;
    }

    private void addSamples(List<Collector.MetricFamilySamples> allSamples, List<Collector.MetricFamilySamples> newSamples, String logMessage) {
        for (Collector.MetricFamilySamples metricFamilySample : newSamples) {
            int sampleCount = metricFamilySample.samples.size();
            if (sampleCount <= 0) continue;
            LOGGER.debug(logMessage, (Object)sampleCount, (Object)metricFamilySample.name);
            allSamples.addAll(newSamples);
        }
    }

    private void addSamples(List<Collector.MetricFamilySamples> allSamples, BuildMetrics buildMetrics) {
        this.addSamples(allSamples, buildMetrics.jobBuildResultOrdinal.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildResult.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildDuration.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildWaitingDurationGauge.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildStartMillis.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildTestsTotal.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildTestsSkipped.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildTestsFailing.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.jobBuildLikelyStuck.collect(), "Adding [{}] samples from gauge ({})");
        this.addSamples(allSamples, buildMetrics.stageSummary.collect(), "Adding [{}] samples from summary ({})");
        this.addSamples(allSamples, buildMetrics.stageBuildResultOrdinal.collect(), "Adding [{}] samples from summary ({})");
        this.addSamples(allSamples, buildMetrics.buildLogFileSizeGauge.collect(), "Adding [{}] samples from summary ({})");
    }

    protected void appendJobMetrics(Job<?, ?> job) {
        boolean isPerBuildMetrics = PrometheusConfiguration.get().isPerBuildMetrics();
        String[] baseLabelValueArray = JobLabel.getBaseLabelValues(job);
        Run buildToCheck = job.getLastBuild();
        if (null == buildToCheck) {
            LOGGER.debug("job [{}] never built", (Object)job.getFullName());
            return;
        }
        if (buildToCheck.isBuilding()) {
            LOGGER.debug("Build [{}] is currently building. Will calculate previous build.", (Object)buildToCheck.number);
            buildToCheck = buildToCheck.getPreviousBuild();
            if (buildToCheck == null) {
                LOGGER.debug("Previous build does not exist. Skipping calculation for [{}].", (Object)job.getFullName());
                return;
            }
        }
        LOGGER.debug("Calculating job metrics for [{}]", (Object)buildToCheck.number);
        this.nbBuildsGauge.calculateMetric(job, baseLabelValueArray);
        this.jobHealthScoreGauge.calculateMetric(job, baseLabelValueArray);
        this.buildDiscardGauge.calculateMetric(job, baseLabelValueArray);
        this.currentRunDurationGauge.calculateMetric(job, baseLabelValueArray);
        this.logUpdatedGauge.calculateMetric(job, baseLabelValueArray);
        this.processRun(job, buildToCheck, baseLabelValueArray, this.lastBuildMetrics);
        for (Run run = buildToCheck; run != null; run = run.getPreviousBuild()) {
            LOGGER.debug("getting metrics for run [{}] from job [{}], include per run metrics [{}]", new Object[]{run.getNumber(), job.getName(), isPerBuildMetrics});
            if (!Runs.includeBuildInMetrics(run)) continue;
            LOGGER.debug("getting build info for run [{}] from job [{}]", (Object)run.getNumber(), (Object)job.getName());
            String[] labelValueArray = JobLabel.getJobLabelValues(job, run);
            this.summary.calculateMetric(run, labelValueArray);
            if (!isPerBuildMetrics) continue;
            labelValueArray = Arrays.copyOf(labelValueArray, labelValueArray.length + 1);
            labelValueArray[labelValueArray.length - 1] = String.valueOf(run.getNumber());
            this.processRun(job, run, labelValueArray, this.perBuildMetrics);
        }
    }

    private void processRun(Job<?, ?> job, Run<?, ?> run, String[] buildLabelValueArray, BuildMetrics buildMetrics) {
        LOGGER.debug("Processing run [{}] from job [{}]", (Object)run.getNumber(), (Object)job.getName());
        buildMetrics.jobBuildResultOrdinal.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildResult.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildStartMillis.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildDuration.calculateMetric(run, buildLabelValueArray);
        buildMetrics.stageSummary.calculateMetric(run, buildLabelValueArray);
        buildMetrics.stageBuildResultOrdinal.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildTestsTotal.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildTestsSkipped.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildTestsFailing.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildLikelyStuck.calculateMetric(run, buildLabelValueArray);
        buildMetrics.buildLogFileSizeGauge.calculateMetric(run, buildLabelValueArray);
        buildMetrics.jobBuildWaitingDurationGauge.calculateMetric(run, buildLabelValueArray);
    }

    private static class BuildMetrics {
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildResultOrdinal;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildResult;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildStartMillis;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildDuration;
        public MetricCollector<Run<?, ?>, ? extends Collector> stageSummary;
        public MetricCollector<Run<?, ?>, ? extends Collector> stageBuildResultOrdinal;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildTestsTotal;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildTestsSkipped;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildTestsFailing;
        public MetricCollector<Run<?, ?>, ? extends Collector> jobBuildLikelyStuck;
        private MetricCollector<Run<?, ?>, ? extends Collector> buildLogFileSizeGauge;
        private MetricCollector<Run<?, ?>, ? extends Collector> jobBuildWaitingDurationGauge;
        private final String buildPrefix;

        public BuildMetrics(String buildPrefix) {
            this.buildPrefix = buildPrefix;
        }

        public void initCollectors(String[] labelNameArray) {
            CollectorFactory factory = new CollectorFactory();
            this.jobBuildResultOrdinal = factory.createRunCollector(CollectorType.BUILD_RESULT_ORDINAL_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildResult = factory.createRunCollector(CollectorType.BUILD_RESULT_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildDuration = factory.createRunCollector(CollectorType.BUILD_DURATION_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildStartMillis = factory.createRunCollector(CollectorType.BUILD_START_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildTestsTotal = factory.createRunCollector(CollectorType.TOTAL_TESTS_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildTestsSkipped = factory.createRunCollector(CollectorType.SKIPPED_TESTS_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildTestsFailing = factory.createRunCollector(CollectorType.FAILED_TESTS_GAUGE, labelNameArray, this.buildPrefix);
            this.stageSummary = factory.createRunCollector(CollectorType.STAGE_SUMMARY, (String[])ArrayUtils.add((Object[])labelNameArray, (Object)"stage"), this.buildPrefix);
            this.stageBuildResultOrdinal = factory.createRunCollector(CollectorType.STAGE_BUILDRESULT_ORDINAL, (String[])ArrayUtils.add((Object[])labelNameArray, (Object)"stage"), this.buildPrefix);
            this.jobBuildLikelyStuck = factory.createRunCollector(CollectorType.BUILD_LIKELY_STUCK_GAUGE, labelNameArray, this.buildPrefix);
            this.buildLogFileSizeGauge = factory.createRunCollector(CollectorType.BUILD_LOGFILE_SIZE_GAUGE, labelNameArray, this.buildPrefix);
            this.jobBuildWaitingDurationGauge = factory.createRunCollector(CollectorType.BUILD_WAITING_GAUGE, labelNameArray, this.buildPrefix);
        }
    }
}

