// CHECKSTYLE:OFF

package org.jenkinsci.plugins.prometheus.config;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code path.required}: {@code Path is required.}.
     * 
     * @return
     *     {@code Path is required.}
     */
    public static String path_required() {
        return holder.format("path.required");
    }

    /**
     * Key {@code path.required}: {@code Path is required.}.
     * 
     * @return
     *     {@code Path is required.}
     */
    public static Localizable _path_required() {
        return new Localizable(holder, "path.required");
    }

    /**
     * Key {@code path.environment.override}: {@code You have still
     * configured the environment variable {0} ({1}) which will be
     * overwritten by this path.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have still configured the environment variable {0} ({1})
     *     which will be overwritten by this path.}
     */
    public static String path_environment_override(Object arg0, Object arg1) {
        return holder.format("path.environment.override", arg0, arg1);
    }

    /**
     * Key {@code path.environment.override}: {@code You have still
     * configured the environment variable {0} ({1}) which will be
     * overwritten by this path.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have still configured the environment variable {0} ({1})
     *     which will be overwritten by this path.}
     */
    public static Localizable _path_environment_override(Object arg0, Object arg1) {
        return new Localizable(holder, "path.environment.override", arg0, arg1);
    }

}
