/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.disk;

import com.cloudbees.simplediskusage.DiskItem;
import com.cloudbees.simplediskusage.JobDiskItem;
import io.prometheus.client.Collector;
import java.nio.file.FileStore;
import java.util.Objects;
import org.jenkinsci.plugins.prometheus.collectors.BaseCollectorFactory;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.NoOpMetricCollector;
import org.jenkinsci.plugins.prometheus.collectors.disk.DiskUsageBytesGauge;
import org.jenkinsci.plugins.prometheus.collectors.disk.DiskUsageFileCountGauge;
import org.jenkinsci.plugins.prometheus.collectors.disk.FileStoreAvailableGauge;
import org.jenkinsci.plugins.prometheus.collectors.disk.FileStoreCapacityGauge;
import org.jenkinsci.plugins.prometheus.collectors.disk.JobUsageBytesGauge;

public class DiskCollectorFactory
extends BaseCollectorFactory {
    public MetricCollector<DiskItem, ? extends Collector> createDiskItemCollector(CollectorType type, String[] labelNames) {
        if (Objects.requireNonNull(type) == CollectorType.DISK_USAGE_BYTES_GAUGE) {
            return this.saveBuildCollector(new DiskUsageBytesGauge(labelNames, this.namespace, this.subsystem));
        }
        if (Objects.requireNonNull(type) == CollectorType.DISK_USAGE_FILE_COUNT_GAUGE) {
            return this.saveBuildCollector(new DiskUsageFileCountGauge(labelNames, this.namespace, this.subsystem));
        }
        return new NoOpMetricCollector();
    }

    public MetricCollector<JobDiskItem, ? extends Collector> createJobDiskItemCollector(CollectorType type, String[] labelNames) {
        if (Objects.requireNonNull(type) == CollectorType.JOB_USAGE_BYTES_GAUGE) {
            return this.saveBuildCollector(new JobUsageBytesGauge(labelNames, this.namespace, this.subsystem));
        }
        return new NoOpMetricCollector();
    }

    public MetricCollector<FileStore, ? extends Collector> createFileStoreCollector(CollectorType type, String[] labelNames) {
        switch (type) {
            case FILE_STORE_AVAILABLE_GAUGE: {
                return this.saveBuildCollector(new FileStoreAvailableGauge(labelNames, this.namespace, this.subsystem));
            }
            case FILE_STORE_CAPACITY_GAUGE: {
                return this.saveBuildCollector(new FileStoreCapacityGauge(labelNames, this.namespace, this.subsystem));
            }
        }
        return new NoOpMetricCollector();
    }
}

