/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors.builds;

import hudson.model.Result;
import hudson.model.Run;
import io.prometheus.client.Gauge;
import io.prometheus.client.SimpleCollector;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.builds.BuildsMetricCollector;

public class BuildResultGauge
extends BuildsMetricCollector<Run<?, ?>, Gauge> {
    protected BuildResultGauge(String[] labelNames, String namespace, String subsystem, String namePrefix) {
        super(labelNames, namespace, subsystem, namePrefix);
    }

    @Override
    protected CollectorType getCollectorType() {
        return CollectorType.BUILD_RESULT_GAUGE;
    }

    @Override
    protected String getHelpText() {
        return "Build status of a job as a boolean (0 or 1)";
    }

    @Override
    protected SimpleCollector.Builder<?, Gauge> getCollectorBuilder() {
        return Gauge.build();
    }

    @Override
    public void calculateMetric(Run<?, ?> jenkinsObject, String[] labelValues) {
        int ordinal = -1;
        Result runResult = jenkinsObject.getResult();
        if (null != runResult) {
            ordinal = runResult.ordinal;
        }
        ((Gauge.Child)((Gauge)this.collector).labels(labelValues)).set(ordinal < 2 ? 1.0 : 0.0);
    }
}

