/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.prometheus.collectors;

import io.prometheus.client.Collector;
import io.prometheus.client.SimpleCollector;
import java.util.List;
import org.jenkinsci.plugins.prometheus.collectors.CollectorType;
import org.jenkinsci.plugins.prometheus.collectors.MetricCollector;

public abstract class BaseMetricCollector<T, I extends SimpleCollector<?>>
implements MetricCollector<T, I> {
    protected static final String SEPARATOR = "_";
    protected final String[] labelNames;
    protected final String namespace;
    protected final String subsystem;
    protected final String namePrefix;
    protected final I collector;

    protected BaseMetricCollector(String[] labelNames, String namespace, String subsystem, String namePrefix) {
        this.labelNames = labelNames;
        this.namespace = namespace;
        this.subsystem = subsystem;
        this.namePrefix = namePrefix;
        this.collector = this.initCollector();
    }

    protected BaseMetricCollector(String[] labelNames, String namespace, String subsystem) {
        this.labelNames = labelNames;
        this.namespace = namespace;
        this.subsystem = subsystem;
        this.namePrefix = "";
        this.collector = this.initCollector();
    }

    protected abstract CollectorType getCollectorType();

    protected abstract String getHelpText();

    protected abstract SimpleCollector.Builder<?, I> getCollectorBuilder();

    protected I initCollector() {
        return (I)this.getCollectorBuilder().name(this.calculateName()).subsystem(this.subsystem).namespace(this.namespace).labelNames(this.labelNames).help(this.getHelpText()).create();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        return this.collector.collect();
    }

    @Override
    public String calculateName() {
        String name = this.getCollectorType().getName();
        StringBuilder sb = new StringBuilder();
        if (this.isBaseNameSet()) {
            sb.append(this.getBaseName()).append(SEPARATOR);
        }
        if (this.isNamePrefixSet()) {
            sb.append(this.namePrefix).append(SEPARATOR);
        }
        return sb.append(name).toString();
    }

    private boolean isBaseNameSet() {
        return this.getBaseName() != null && !"".equals(this.getBaseName());
    }

    private boolean isNamePrefixSet() {
        return this.namePrefix != null && !this.namePrefix.isEmpty();
    }

    protected String getBaseName() {
        return "";
    }

    @Override
    public abstract void calculateMetric(T var1, String[] var2);
}

