/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.preSCMbuildstep;

import hudson.AbortException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildTrigger;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.kohsuke.stapler.DataBoundConstructor;

public class PreSCMBuildStepsWrapper
extends BuildWrapper {
    public final ArrayList<BuildStep> buildSteps;
    public final boolean failOnError;

    @DataBoundConstructor
    public PreSCMBuildStepsWrapper(ArrayList<BuildStep> buildstep, boolean failOnError) {
        this.buildSteps = buildstep;
        this.failOnError = failOnError;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new NoopEnv();
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        if (!build.getWorkspace().exists()) {
            build.getWorkspace().mkdirs();
        }
        if (this.buildSteps == null) {
            log.println("No build steps declared");
            return;
        }
        log.println("Running Prebuild steps");
        for (BuildStep bs : this.buildSteps) {
            if (bs.prebuild(build, listener)) continue;
            log.println("Failed pre build for " + bs.toString());
            if (!this.failOnError) continue;
            throw new AbortException("pre-build step failed to setup environment");
        }
        for (BuildStep bs : this.buildSteps) {
            if (bs instanceof BuildTrigger) {
                BuildTrigger bt = (BuildTrigger)bs;
                for (AbstractProject p : bt.getChildProjects()) {
                    log.println("Triggering build for " + p.getDisplayName());
                    p.scheduleBuild(0, (Cause)new Cause.LegacyCodeCause());
                }
                continue;
            }
            if (!bs.perform(build, launcher, listener)) {
                log.println("Failed build for " + bs.toString());
                if (!this.failOnError) continue;
                throw new AbortException("pre-build step failed to setup environment");
            }
            log.println("Success build for" + bs.toString());
        }
    }

    class NoopEnv
    extends BuildWrapper.Environment {
        NoopEnv() {
            super((BuildWrapper)PreSCMBuildStepsWrapper.this);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BuildWrapper> {
        public String getDisplayName() {
            return "Run buildstep before SCM runs";
        }
    }
}

