/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.powershell;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.powershell.PowerShellInstallation;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.CommandInterpreter;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.SystemUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PowerShell
extends CommandInterpreter {
    private final boolean useProfile;
    private Integer unstableReturn;
    private final boolean stopOnError;
    private transient TaskListener listener;

    @DataBoundConstructor
    public PowerShell(String command, boolean stopOnError, boolean useProfile, Integer unstableReturn) {
        super(command);
        this.stopOnError = stopOnError;
        this.useProfile = useProfile;
        this.unstableReturn = unstableReturn;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        this.listener = listener;
        return super.perform(build, launcher, listener);
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public boolean isUseProfile() {
        return this.useProfile;
    }

    protected String getFileExtension() {
        return ".ps1";
    }

    @CheckForNull
    public final Integer getUnstableReturn() {
        return Integer.valueOf(0).equals(this.unstableReturn) ? null : this.unstableReturn;
    }

    @DataBoundSetter
    public void setUnstableReturn(Integer unstableReturn) {
        this.unstableReturn = unstableReturn;
    }

    protected boolean isErrorlevelForUnstableBuild(int exitCode) {
        return this.unstableReturn != null && exitCode != 0 && this.unstableReturn.equals(exitCode);
    }

    public String[] buildCommandLine(FilePath script) {
        String powerShellExecutable = null;
        PowerShellInstallation installation = null;
        installation = this.isRunningOnWindows(script) ? ((PowerShellInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(PowerShellInstallation.DescriptorImpl.class)).getAnyInstallation("DefaultWindows") : ((PowerShellInstallation.DescriptorImpl)Jenkins.get().getDescriptorByType(PowerShellInstallation.DescriptorImpl.class)).getAnyInstallation("DefaultLinux");
        if (installation != null) {
            Node node = PowerShell.filePathToNode(script);
            try {
                powerShellExecutable = node != null && installation.forNode(node, this.listener) != null ? installation.forNode(node, this.listener).getPowerShellBinary() : installation.getPowerShellBinary();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (powerShellExecutable == null) {
            powerShellExecutable = PowerShellInstallation.getDefaultPowershellWhenNoConfiguration(this.isRunningOnWindows(script));
        }
        if (this.isRunningOnWindows(script)) {
            if (this.useProfile) {
                return new String[]{powerShellExecutable, "-NonInteractive", "-ExecutionPolicy", "Bypass", "-File", script.getRemote()};
            }
            return new String[]{powerShellExecutable, "-NoProfile", "-NonInteractive", "-ExecutionPolicy", "Bypass", "-File", script.getRemote()};
        }
        if (this.useProfile) {
            return new String[]{powerShellExecutable, "-NonInteractive", "-File", script.getRemote()};
        }
        return new String[]{powerShellExecutable, "-NonInteractive", "-NoProfile", "-File", script.getRemote()};
    }

    protected String getContents() {
        StringBuilder sb = new StringBuilder();
        if (this.stopOnError) {
            sb.append("$ErrorActionPreference=\"Stop\"");
            sb.append(System.lineSeparator());
        }
        sb.append(this.command);
        sb.append(System.lineSeparator());
        sb.append("exit $LastExitCode");
        return sb.toString();
    }

    private boolean isRunningOnWindows(FilePath script) {
        if (!script.isRemote()) {
            return SystemUtils.IS_OS_WINDOWS;
        }
        String path = script.getRemote();
        return path.length() > 3 && path.charAt(1) == ':' && path.charAt(2) == '\\';
    }

    private static Node filePathToNode(FilePath script) {
        Computer computer = script.toComputer();
        Node node = null;
        if (computer != null) {
            node = computer.getNode();
        }
        return node;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getHelpFile() {
            return "/plugin/powershell/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "PowerShell";
        }
    }
}

