/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.powershell;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class PowerShellInstallation
extends ToolInstallation
implements NodeSpecific<PowerShellInstallation>,
EnvironmentSpecific<PowerShellInstallation> {
    public static final transient String DEFAULTWINDOWS = "DefaultWindows";
    public static final transient String DEFAULTLINUX = "DefaultLinux";
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public PowerShellInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public PowerShellInstallation forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new PowerShellInstallation(this.getName(), this.translateFor(node, log), (List<? extends ToolProperty<?>>)this.getProperties());
    }

    public PowerShellInstallation forEnvironment(EnvVars environment) {
        return new PowerShellInstallation(this.getName(), environment.expand(this.getHome()), (List<? extends ToolProperty<?>>)this.getProperties());
    }

    public static String getDefaultPowershellWhenNoConfiguration(Boolean isRunningOnWindows) {
        if (isRunningOnWindows.booleanValue()) {
            return "powershell.exe";
        }
        return "pwsh";
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void onLoaded() {
        DescriptorImpl descriptor = (DescriptorImpl)Jenkins.get().getDescriptor(PowerShellInstallation.class);
        assert (descriptor != null);
        PowerShellInstallation[] installations = (PowerShellInstallation[])descriptor.getInstallations();
        if (installations != null && installations.length > 0) {
            return;
        }
        PowerShellInstallation windowsInstallation = new PowerShellInstallation(DEFAULTWINDOWS, "powershell.exe", null);
        PowerShellInstallation linuxInstallation = new PowerShellInstallation(DEFAULTLINUX, "pwsh", null);
        ToolInstallation[] defaultInstallations = new PowerShellInstallation[]{windowsInstallation, linuxInstallation};
        descriptor.setInstallations(defaultInstallations);
        descriptor.save();
    }

    public String getPowerShellBinary() {
        return this.getHome();
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<PowerShellInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "PowerShell";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            this.setInstallations(req.bindJSONToList(PowerShellInstallation.class, json.get("tool")).toArray((PowerShellInstallation[])Array.newInstance(PowerShellInstallation.class, 0)));
            this.save();
            return true;
        }

        @Nullable
        public PowerShellInstallation getInstallation(String name) {
            for (PowerShellInstallation i : (PowerShellInstallation[])this.getInstallations()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Nullable
        public PowerShellInstallation getAnyInstallation(String name) {
            PowerShellInstallation defaultInstallation = this.getInstallation(name);
            if (defaultInstallation != null) {
                return defaultInstallation;
            }
            if (((PowerShellInstallation[])this.getInstallations()).length > 0) {
                return ((PowerShellInstallation[])this.getInstallations())[0];
            }
            return null;
        }
    }
}

