/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.service;

import hudson.FilePath;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.postbuildscript.Messages;
import org.jenkinsci.plugins.postbuildscript.PostBuildScriptException;
import org.jenkinsci.plugins.postbuildscript.logging.Logger;
import org.jenkinsci.plugins.postbuildscript.model.Script;
import org.jenkinsci.plugins.postbuildscript.model.ScriptFile;
import org.jenkinsci.plugins.postbuildscript.service.Command;
import org.jenkinsci.plugins.postbuildscript.service.Content;
import org.jenkinsci.plugins.postbuildscript.service.GroovyScriptExecutor;
import org.jenkinsci.plugins.postbuildscript.service.GroovyScriptExecutorFactory;
import org.jenkinsci.plugins.postbuildscript.service.LoadScriptContentCallable;
import org.jenkinsci.plugins.postbuildscript.service.ScriptFilePath;

public class GroovyScriptPreparer
implements Serializable {
    private static final long serialVersionUID = 6304738377691375266L;
    private final Logger logger;
    private final transient GroovyScriptExecutorFactory groovyScriptExecutorFactory;
    private final FilePath workspace;

    public GroovyScriptPreparer(Logger logger, FilePath workspace, GroovyScriptExecutorFactory groovyScriptExecutorFactory) {
        this.logger = logger;
        this.workspace = workspace;
        this.groovyScriptExecutorFactory = groovyScriptExecutorFactory;
    }

    public boolean evaluateScript(Script script) {
        return this.evaluateScript(script, Collections.emptyList());
    }

    public boolean evaluateScript(Script script, List<String> arguments) {
        if (script == null || script.getContent() == null) {
            throw new IllegalArgumentException("The script content object must be set.");
        }
        if (this.workspaceIsNull()) {
            return false;
        }
        try {
            GroovyScriptExecutor groovyScriptExecutor = this.groovyScriptExecutorFactory.create(script, arguments);
            groovyScriptExecutor.execute();
        }
        catch (Exception exception) {
            this.logger.info(Messages.PostBuildScript_ProblemOccured(), exception);
            return false;
        }
        return true;
    }

    private boolean workspaceIsNull() {
        if (this.workspace == null) {
            this.logger.info(Messages.PostBuildScript_WorkspaceEmpty());
            return true;
        }
        return false;
    }

    public boolean evaluateCommand(ScriptFile scriptFile, Command command) throws PostBuildScriptException {
        if (this.workspaceIsNull()) {
            return false;
        }
        FilePath filePath = new ScriptFilePath(this.workspace).resolve(command.getScriptPath());
        LoadScriptContentCallable callable = new LoadScriptContentCallable();
        String scriptContent = new Content((FilePath.FileCallable<String>)callable).resolve(filePath);
        Script script = new Script(scriptFile.getResults(), scriptContent);
        script.setSandboxed(scriptFile.isSandboxed());
        return this.evaluateScript(script, command.getParameters());
    }
}

