/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.service;

import hudson.FilePath;
import java.io.IOException;
import org.jenkinsci.plugins.postbuildscript.Messages;
import org.jenkinsci.plugins.postbuildscript.PostBuildScriptException;
import org.jenkinsci.plugins.postbuildscript.service.LoadFileCallable;

public class ScriptFilePath {
    private final FilePath workspace;

    public ScriptFilePath(FilePath workspace) {
        this.workspace = workspace;
    }

    public FilePath resolve(String command) throws PostBuildScriptException {
        FilePath filePath = this.getFilePath(command);
        if (filePath == null) {
            throw new PostBuildScriptException(Messages.PostBuildScript_ScriptFilePathDoesNotExist(command));
        }
        return filePath;
    }

    private FilePath getFilePath(String givenPath) throws PostBuildScriptException {
        try {
            return (FilePath)this.workspace.act((FilePath.FileCallable)new LoadFileCallable(givenPath, this.workspace));
        }
        catch (IOException | InterruptedException ioe) {
            throw new PostBuildScriptException("Error to resolve script path", ioe);
        }
    }
}

