/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.processor;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jenkinsci.plugins.postbuildscript.Messages;
import org.jenkinsci.plugins.postbuildscript.PostBuildScriptException;
import org.jenkinsci.plugins.postbuildscript.logging.Logger;
import org.jenkinsci.plugins.postbuildscript.model.Configuration;
import org.jenkinsci.plugins.postbuildscript.model.PostBuildItem;
import org.jenkinsci.plugins.postbuildscript.model.PostBuildStep;
import org.jenkinsci.plugins.postbuildscript.model.Script;
import org.jenkinsci.plugins.postbuildscript.model.ScriptFile;
import org.jenkinsci.plugins.postbuildscript.model.ScriptType;
import org.jenkinsci.plugins.postbuildscript.processor.rules.ExecutionRule;
import org.jenkinsci.plugins.postbuildscript.service.Command;
import org.jenkinsci.plugins.postbuildscript.service.CommandExecutor;
import org.jenkinsci.plugins.postbuildscript.service.GroovyScriptExecutorFactory;
import org.jenkinsci.plugins.postbuildscript.service.GroovyScriptPreparer;

public class Processor {
    private final AbstractBuild<?, ?> build;
    private final Launcher launcher;
    private final BuildListener listener;
    private final Configuration config;
    private final Logger logger;
    private final Collection<ExecutionRule> rules = new ArrayList<ExecutionRule>();

    public Processor(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, Configuration config) {
        this.build = build;
        Result result = build.getResult();
        this.launcher = result == null ? launcher : launcher.decorateByEnv(new EnvVars(new String[]{"BUILD_RESULT", result.toString()}));
        this.listener = listener;
        this.config = config;
        this.logger = new Logger((TaskListener)listener, build);
    }

    public void addRule(ExecutionRule rule) {
        this.rules.add(rule);
    }

    private Command getResolvedCommand(String command) throws PostBuildScriptException {
        if (command == null) {
            return null;
        }
        try {
            String resolvedPath = Util.replaceMacro((String)command, (Map)this.build.getEnvironment((TaskListener)this.listener));
            resolvedPath = Util.replaceMacro((String)resolvedPath, (Map)this.build.getBuildVariables());
            return new Command(resolvedPath);
        }
        catch (IOException | InterruptedException ioe) {
            throw new PostBuildScriptException(ioe);
        }
    }

    public boolean process() {
        return this.process(false);
    }

    public boolean process(boolean endOfMatrixBuild) {
        this.logger.info(Messages.PostBuildScript_ExecutingPostBuildScripts());
        try {
            return this.processScripts(endOfMatrixBuild);
        }
        catch (PostBuildScriptException pse) {
            this.logger.error(Messages.PostBuildScript_ProblemOccured(), pse);
            this.failOrUnstable();
            return false;
        }
    }

    private boolean processScripts(boolean endOfMatrixBuild) throws PostBuildScriptException {
        boolean everyScriptSuccessful = this.processScriptFiles(endOfMatrixBuild) & this.processGroovyScripts(endOfMatrixBuild) & this.processBuildSteps(endOfMatrixBuild);
        return everyScriptSuccessful || this.failOrUnstable();
    }

    private boolean failOrUnstable() {
        if (this.config.isMarkBuildUnstable()) {
            this.build.setResult(Result.UNSTABLE);
            return true;
        }
        this.build.setResult(Result.FAILURE);
        return false;
    }

    private boolean processScriptFiles(boolean endOfMatrixBuild) throws PostBuildScriptException {
        FilePath workspace = this.build.getWorkspace();
        CommandExecutor commandExecutor = new CommandExecutor(this.logger, (TaskListener)this.listener, workspace, this.launcher);
        GroovyScriptPreparer scriptPreparer = this.createGroovyScriptPreparer();
        boolean everyStepSuccessful = true;
        for (ScriptFile scriptFile : this.config.getScriptFiles()) {
            Command command;
            String filePath = scriptFile.getFilePath();
            if (Strings.nullToEmpty((String)filePath).trim().isEmpty()) {
                this.logger.error(Messages.PostBuildScript_NoFilePathProvided(this.config.scriptFileIndexOf(scriptFile)));
                continue;
            }
            if (this.violatesAnyRule(scriptFile, filePath, endOfMatrixBuild) || (command = this.getResolvedCommand(filePath)) == null) continue;
            if (scriptFile.getScriptType() == ScriptType.GENERIC) {
                int returnCode = commandExecutor.executeCommand(command);
                if (returnCode == 0) continue;
                everyStepSuccessful = false;
                continue;
            }
            if (scriptPreparer.evaluateCommand(scriptFile, command)) continue;
            everyStepSuccessful = false;
        }
        return everyStepSuccessful;
    }

    private boolean processGroovyScripts(boolean endOfMatrixBuild) {
        GroovyScriptPreparer executor = this.createGroovyScriptPreparer();
        boolean everyStepSuccessful = true;
        for (Script script : this.config.getGroovyScripts()) {
            String content;
            String scriptName;
            if (this.violatesAnyRule(script, scriptName = Messages.PostBuildScript_GroovyScript(this.config.groovyScriptIndexOf(script)), endOfMatrixBuild) || (content = script.getContent()) == null || executor.evaluateScript(script)) continue;
            everyStepSuccessful = false;
        }
        return everyStepSuccessful;
    }

    private GroovyScriptPreparer createGroovyScriptPreparer() {
        FilePath workspace = this.build.getWorkspace();
        GroovyScriptExecutorFactory executorFactory = new GroovyScriptExecutorFactory(this.build, this.logger);
        return new GroovyScriptPreparer(this.logger, workspace, executorFactory);
    }

    private boolean processBuildSteps(boolean endOfMatrixBuild) throws PostBuildScriptException {
        try {
            boolean everyStepSuccessful = true;
            for (PostBuildStep postBuildStep : this.config.getBuildSteps()) {
                String scriptName;
                if (this.violatesAnyRule(postBuildStep, scriptName = Messages.PostBuildScript_BuildStep(this.config.buildStepIndexOf(postBuildStep)), endOfMatrixBuild)) continue;
                for (BuildStep buildStep : postBuildStep.getBuildSteps()) {
                    boolean buildSucceed;
                    try {
                        buildSucceed = buildStep.perform(this.build, this.launcher, this.listener);
                    }
                    catch (AbortException e) {
                        buildSucceed = false;
                    }
                    everyStepSuccessful &= buildSucceed;
                    if (buildSucceed || !postBuildStep.isStopOnFailure()) continue;
                    return false;
                }
            }
            return everyStepSuccessful;
        }
        catch (IOException | InterruptedException ioe) {
            throw new PostBuildScriptException(ioe);
        }
    }

    private boolean violatesAnyRule(PostBuildItem item, String scriptName, boolean endOfMatrixBuild) {
        for (ExecutionRule rule : this.rules) {
            if (rule.allows(item, endOfMatrixBuild)) continue;
            this.logger.info(rule.formatViolationMessage(item, scriptName));
            return true;
        }
        return false;
    }
}

