/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.logging;

import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.jenkinsci.plugins.postbuildscript.logging.LoggerInitializationException;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;

public class Logger
extends LegacyAbstractLogger {
    private static final long serialVersionUID = 1083402096308867767L;
    private static final String FULLY_QUALIFIED_CALLER_NAME = Logger.class.getName();
    private final TaskListener listener;
    private final boolean verbose;

    public Logger(TaskListener listener, AbstractBuild<?, ?> build) {
        this.listener = listener;
        try {
            this.verbose = Boolean.parseBoolean(build.getEnvironment(listener).get("POSTBUILDSCRIPT_VERBOSE", "false"));
        }
        catch (Exception e) {
            throw new LoggerInitializationException(e);
        }
    }

    public TaskListener getListener() {
        return this.listener;
    }

    protected String getFullyQualifiedCallerName() {
        return FULLY_QUALIFIED_CALLER_NAME;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String messagePattern, Object[] arguments, Throwable throwable) {
        PrintStream logger = this.listener.getLogger();
        logger.print("[PostBuildScript] - ");
        logger.print('[');
        logger.print(level.name());
        logger.print("] ");
        logger.println(MessageFormatter.basicArrayFormat((String)messagePattern, (Object[])arguments));
        if (throwable != null) {
            throwable.printStackTrace(logger);
        }
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return this.verbose;
    }

    public boolean isDebugEnabled() {
        return this.verbose;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }
}

