/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript;

import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jenkinsci.plugins.postbuildscript.MatrixPostBuildScript;
import org.jenkinsci.plugins.postbuildscript.Messages;
import org.jenkinsci.plugins.postbuildscript.PostBuildScript;
import org.jenkinsci.plugins.postbuildscript.logging.Logger;
import org.jenkinsci.plugins.postbuildscript.processor.Processor;
import org.jenkinsci.plugins.postbuildscript.processor.ProcessorFactory;

public class ConfigurableMatrixAggregator
extends MatrixAggregator {
    private final Processor processor;
    private final Class<? extends PostBuildScript> initiator;
    private final Logger logger;

    public ConfigurableMatrixAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, ProcessorFactory processorFactory, Class<? extends PostBuildScript> initiator) {
        super(build, launcher, listener);
        this.initiator = initiator;
        this.processor = processorFactory.createMatrixProcessor((AbstractBuild<?, ?>)build, launcher, listener);
        this.logger = new Logger((TaskListener)listener, (AbstractBuild<?, ?>)build);
    }

    public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
        if (!MatrixPostBuildScript.class.isAssignableFrom(this.initiator)) {
            this.logger.warn(Messages.PostBuildScript_DeprecatedUsageOfMatrixOptions());
        }
        this.logger.debug("endRun: {}", run);
        this.listener.getLogger().println();
        return super.endRun(run);
    }

    public boolean endBuild() {
        if (!MatrixPostBuildScript.class.isAssignableFrom(this.initiator)) {
            this.logger.warn(Messages.PostBuildScript_DeprecatedUsageOfMatrixOptions());
        }
        this.logger.debug("endBuild");
        return this.processor.process(true);
    }
}

