/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.service;

import groovy.lang.Binding;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.postbuildscript.logging.Logger;
import org.jenkinsci.plugins.postbuildscript.model.Script;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;

public class GroovyScriptExecutor {
    private static final long serialVersionUID = 3874477459736242748L;
    private final List<String> arguments;
    private final transient AbstractBuild<?, ?> build;
    private final Logger log;
    private final SecureGroovyScript secureGroovyScript;

    public GroovyScriptExecutor(Script script, List<String> arguments, AbstractBuild<?, ?> build, Logger log) throws Descriptor.FormException {
        this.arguments = new ArrayList<String>(arguments);
        this.build = build;
        this.log = log;
        String enrichedScript = Util.replaceMacro((String)script.getContent(), (Map)EnvVars.masterEnvVars);
        this.secureGroovyScript = new SecureGroovyScript(enrichedScript, script.isSandboxed(), null);
        this.secureGroovyScript.configuringWithNonKeyItem();
    }

    public void execute() throws Exception {
        Binding binding = new Binding();
        if (this.build != null) {
            FilePath workspace = this.build.getWorkspace();
            if (workspace != null && workspace.getRemote() != null) {
                binding.setVariable("workspace", (Object)new File(workspace.getRemote()));
            }
            binding.setVariable("build", this.build);
        }
        binding.setVariable("log", (Object)this.log);
        binding.setVariable("out", (Object)this.log.getListener().getLogger());
        binding.setVariable("args", this.arguments);
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.secureGroovyScript.evaluate(classLoader, binding, this.log.getListener());
    }
}

