/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.postbuildscript.model.ExecuteOn;
import org.jenkinsci.plugins.postbuildscript.model.Role;
import org.kohsuke.stapler.DataBoundSetter;

public class PostBuildItem {
    private Set<String> results = new HashSet<String>();
    private Role role = Role.BOTH;
    private ExecuteOn executeOn;

    public PostBuildItem(@Nullable Collection<String> results) {
        if (results != null) {
            this.results.addAll(results);
        }
    }

    public boolean shouldBeExecuted(@Nullable String result) {
        return this.results.contains(result);
    }

    public Set<String> getResults() {
        return Collections.unmodifiableSet(this.results);
    }

    public boolean hasResult() {
        return !this.results.isEmpty();
    }

    public void addResults(@NonNull Collection<String> results) {
        this.results.addAll(results);
    }

    @DataBoundSetter
    public void setRole(Role role) {
        this.role = role;
    }

    public boolean shouldRunOnMaster() {
        return this.role == Role.MASTER || this.role == Role.BOTH;
    }

    public boolean shouldRunOnSlave() {
        return this.role == Role.SLAVE || this.role == Role.BOTH;
    }

    public Role getRole() {
        return this.role;
    }

    public ExecuteOn getExecuteOn() {
        return this.executeOn;
    }

    @DataBoundSetter
    public void setExecuteOn(ExecuteOn executeOn) {
        this.executeOn = executeOn;
    }

    public Object readResolve() {
        if (this.results == null) {
            this.results = new HashSet<String>();
        }
        if (this.role == null) {
            this.role = Role.BOTH;
        }
        if (this.executeOn == null) {
            this.executeOn = ExecuteOn.BOTH;
        }
        return this;
    }
}

