/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.postbuildscript.model.PostBuildStep;
import org.jenkinsci.plugins.postbuildscript.model.Script;
import org.jenkinsci.plugins.postbuildscript.model.ScriptFile;
import org.jenkinsci.plugins.postbuildscript.model.ScriptType;

public class Configuration {
    private List<ScriptFile> scriptFiles = new ArrayList<ScriptFile>();
    private final List<Script> groovyScripts = new ArrayList<Script>();
    private final List<PostBuildStep> buildSteps = new ArrayList<PostBuildStep>();
    private boolean markBuildUnstable;

    public List<PostBuildStep> getBuildSteps() {
        return Collections.unmodifiableList(this.buildSteps);
    }

    public int buildStepIndexOf(PostBuildStep postBuildStep) {
        return this.buildSteps.indexOf(postBuildStep);
    }

    public boolean isMarkBuildUnstable() {
        return this.markBuildUnstable;
    }

    public void setMarkBuildUnstable(boolean markBuildUnstable) {
        this.markBuildUnstable = markBuildUnstable;
    }

    public List<ScriptFile> getScriptFiles() {
        return Collections.unmodifiableList(this.scriptFiles);
    }

    public List<ScriptFile> getScriptFiles(ScriptType scriptType) {
        return this.scriptFiles.stream().filter(scriptFile -> scriptFile.getScriptType() == scriptType).collect(Collectors.toList());
    }

    public int scriptFileIndexOf(ScriptFile scriptFile) {
        return this.scriptFiles.indexOf(scriptFile);
    }

    public List<Script> getGroovyScripts() {
        return Collections.unmodifiableList(this.groovyScripts);
    }

    public int groovyScriptIndexOf(Script script) {
        return this.groovyScripts.indexOf(script);
    }

    public void addScriptFiles(Collection<? extends ScriptFile> scriptFiles) {
        this.scriptFiles.addAll(scriptFiles);
    }

    public void addGroovyScripts(Collection<? extends Script> groovyScripts) {
        this.groovyScripts.addAll(groovyScripts);
    }

    public void addBuildSteps(Collection<? extends PostBuildStep> buildSteps) {
        this.buildSteps.addAll(buildSteps);
    }

    public void addBuildStep(PostBuildStep postBuildStep) {
        this.buildSteps.add(postBuildStep);
    }
}

