// CHECKSTYLE:OFF

package org.jenkinsci.plugins.postbuildscript;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code PostBuildScript.BuildDoesNotFit}: {@code Build does not
     * have any of the results {0}. Did not execute {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build does not have any of the results {0}. Did not execute
     *     {1}.}
     */
    public static String PostBuildScript_BuildDoesNotFit(Object arg0, Object arg1) {
        return holder.format("PostBuildScript.BuildDoesNotFit", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.BuildDoesNotFit}: {@code Build does not
     * have any of the results {0}. Did not execute {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build does not have any of the results {0}. Did not execute
     *     {1}.}
     */
    public static Localizable _PostBuildScript_BuildDoesNotFit(Object arg0, Object arg1) {
        return new Localizable(holder, "PostBuildScript.BuildDoesNotFit", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.ExecutingScript}: {@code Executing the
     * script {0} with parameters {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Executing the script {0} with parameters {1}.}
     */
    public static String PostBuildScript_ExecutingScript(Object arg0, Object arg1) {
        return holder.format("PostBuildScript.ExecutingScript", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.ExecutingScript}: {@code Executing the
     * script {0} with parameters {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Executing the script {0} with parameters {1}.}
     */
    public static Localizable _PostBuildScript_ExecutingScript(Object arg0, Object arg1) {
        return new Localizable(holder, "PostBuildScript.ExecutingScript", arg0, arg1);
    }

    /**
     * Key {@code MatrixPostBuildScript.DisplayName}: {@code Execute scripts
     * on Matrix}.
     * 
     * @return
     *     {@code Execute scripts on Matrix}
     */
    public static String MatrixPostBuildScript_DisplayName() {
        return holder.format("MatrixPostBuildScript.DisplayName");
    }

    /**
     * Key {@code MatrixPostBuildScript.DisplayName}: {@code Execute scripts
     * on Matrix}.
     * 
     * @return
     *     {@code Execute scripts on Matrix}
     */
    public static Localizable _MatrixPostBuildScript_DisplayName() {
        return new Localizable(holder, "MatrixPostBuildScript.DisplayName");
    }

    /**
     * Key {@code PostBuildScript.DeprecatedUsageOfMatrixOptions}: {@code
     * This multi-configuration project post-build action was migrated from a
     * plugin version prior to 1.0.0 as an ''Execute scripts'' post-build
     * action, because is not possible to automatically migrate a post-build
     * action to another kind of post-build action. To remove the mandatory
     * dependency between post-build script plugin and the matrix plugin,
     * there is an extra post-build action called ''Execute Scripts on
     * Matrix''. Please add all post-build scripts of this matrix project
     * separately as a post-build action ''Execute Scripts on Matrix'' and
     * remove all ''Execute Scripts'' entries.}.
     * 
     * @return
     *     {@code This multi-configuration project post-build action was migrated
     *     from a plugin version prior to 1.0.0 as an ''Execute scripts''
     *     post-build action, because is not possible to automatically migrate a
     *     post-build action to another kind of post-build action. To remove the
     *     mandatory dependency between post-build script plugin and the matrix
     *     plugin, there is an extra post-build action called ''Execute Scripts
     *     on Matrix''. Please add all post-build scripts of this matrix project
     *     separately as a post-build action ''Execute Scripts on Matrix'' and
     *     remove all ''Execute Scripts'' entries.}
     */
    public static String PostBuildScript_DeprecatedUsageOfMatrixOptions() {
        return holder.format("PostBuildScript.DeprecatedUsageOfMatrixOptions");
    }

    /**
     * Key {@code PostBuildScript.DeprecatedUsageOfMatrixOptions}: {@code
     * This multi-configuration project post-build action was migrated from a
     * plugin version prior to 1.0.0 as an ''Execute scripts'' post-build
     * action, because is not possible to automatically migrate a post-build
     * action to another kind of post-build action. To remove the mandatory
     * dependency between post-build script plugin and the matrix plugin,
     * there is an extra post-build action called ''Execute Scripts on
     * Matrix''. Please add all post-build scripts of this matrix project
     * separately as a post-build action ''Execute Scripts on Matrix'' and
     * remove all ''Execute Scripts'' entries.}.
     * 
     * @return
     *     {@code This multi-configuration project post-build action was migrated
     *     from a plugin version prior to 1.0.0 as an ''Execute scripts''
     *     post-build action, because is not possible to automatically migrate a
     *     post-build action to another kind of post-build action. To remove the
     *     mandatory dependency between post-build script plugin and the matrix
     *     plugin, there is an extra post-build action called ''Execute Scripts
     *     on Matrix''. Please add all post-build scripts of this matrix project
     *     separately as a post-build action ''Execute Scripts on Matrix'' and
     *     remove all ''Execute Scripts'' entries.}
     */
    public static Localizable _PostBuildScript_DeprecatedUsageOfMatrixOptions() {
        return new Localizable(holder, "PostBuildScript.DeprecatedUsageOfMatrixOptions");
    }

    /**
     * Key {@code PostBuildScript.WorkspaceEmpty}: {@code Workspace is null.
     * Cannot execute Groovy script.}.
     * 
     * @return
     *     {@code Workspace is null. Cannot execute Groovy script.}
     */
    public static String PostBuildScript_WorkspaceEmpty() {
        return holder.format("PostBuildScript.WorkspaceEmpty");
    }

    /**
     * Key {@code PostBuildScript.WorkspaceEmpty}: {@code Workspace is null.
     * Cannot execute Groovy script.}.
     * 
     * @return
     *     {@code Workspace is null. Cannot execute Groovy script.}
     */
    public static Localizable _PostBuildScript_WorkspaceEmpty() {
        return new Localizable(holder, "PostBuildScript.WorkspaceEmpty");
    }

    /**
     * Key {@code PostBuildScript.DisplayName}: {@code Execute scripts}.
     * 
     * @return
     *     {@code Execute scripts}
     */
    public static String PostBuildScript_DisplayName() {
        return holder.format("PostBuildScript.DisplayName");
    }

    /**
     * Key {@code PostBuildScript.DisplayName}: {@code Execute scripts}.
     * 
     * @return
     *     {@code Execute scripts}
     */
    public static Localizable _PostBuildScript_DisplayName() {
        return new Localizable(holder, "PostBuildScript.DisplayName");
    }

    /**
     * Key {@code PostBuildScript.OnlyExecuteOn}: {@code {0} should only be
     * executed on {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} should only be executed on {1}}
     */
    public static String PostBuildScript_OnlyExecuteOn(Object arg0, Object arg1) {
        return holder.format("PostBuildScript.OnlyExecuteOn", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.OnlyExecuteOn}: {@code {0} should only be
     * executed on {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} should only be executed on {1}}
     */
    public static Localizable _PostBuildScript_OnlyExecuteOn(Object arg0, Object arg1) {
        return new Localizable(holder, "PostBuildScript.OnlyExecuteOn", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.BuildStep}: {@code build step #{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code build step #{0}}
     */
    public static String PostBuildScript_BuildStep(Object arg0) {
        return holder.format("PostBuildScript.BuildStep", arg0);
    }

    /**
     * Key {@code PostBuildScript.BuildStep}: {@code build step #{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code build step #{0}}
     */
    public static Localizable _PostBuildScript_BuildStep(Object arg0) {
        return new Localizable(holder, "PostBuildScript.BuildStep", arg0);
    }

    /**
     * Key {@code PostBuildScript.ScriptFilePathDoesNotExist}: {@code The
     * script file path ''{0}'' doesn''t exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script file path ''{0}'' doesn''t exist.}
     */
    public static String PostBuildScript_ScriptFilePathDoesNotExist(Object arg0) {
        return holder.format("PostBuildScript.ScriptFilePathDoesNotExist", arg0);
    }

    /**
     * Key {@code PostBuildScript.ScriptFilePathDoesNotExist}: {@code The
     * script file path ''{0}'' doesn''t exist.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The script file path ''{0}'' doesn''t exist.}
     */
    public static Localizable _PostBuildScript_ScriptFilePathDoesNotExist(Object arg0) {
        return new Localizable(holder, "PostBuildScript.ScriptFilePathDoesNotExist", arg0);
    }

    /**
     * Key {@code PostBuildScript.GroovyScript}: {@code Groovy script #{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Groovy script #{0}}
     */
    public static String PostBuildScript_GroovyScript(Object arg0) {
        return holder.format("PostBuildScript.GroovyScript", arg0);
    }

    /**
     * Key {@code PostBuildScript.GroovyScript}: {@code Groovy script #{0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Groovy script #{0}}
     */
    public static Localizable _PostBuildScript_GroovyScript(Object arg0) {
        return new Localizable(holder, "PostBuildScript.GroovyScript", arg0);
    }

    /**
     * Key {@code PostBuildScript.NodeDoesNotHaveRole}: {@code Node does not
     * have the role {0}. Did not execute {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Node does not have the role {0}. Did not execute {1}.}
     */
    public static String PostBuildScript_NodeDoesNotHaveRole(Object arg0, Object arg1) {
        return holder.format("PostBuildScript.NodeDoesNotHaveRole", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.NodeDoesNotHaveRole}: {@code Node does not
     * have the role {0}. Did not execute {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Node does not have the role {0}. Did not execute {1}.}
     */
    public static Localizable _PostBuildScript_NodeDoesNotHaveRole(Object arg0, Object arg1) {
        return new Localizable(holder, "PostBuildScript.NodeDoesNotHaveRole", arg0, arg1);
    }

    /**
     * Key {@code PostBuildScript.ProblemOccured}: {@code An error occured
     * during post-build processing.}.
     * 
     * @return
     *     {@code An error occured during post-build processing.}
     */
    public static String PostBuildScript_ProblemOccured() {
        return holder.format("PostBuildScript.ProblemOccured");
    }

    /**
     * Key {@code PostBuildScript.ProblemOccured}: {@code An error occured
     * during post-build processing.}.
     * 
     * @return
     *     {@code An error occured during post-build processing.}
     */
    public static Localizable _PostBuildScript_ProblemOccured() {
        return new Localizable(holder, "PostBuildScript.ProblemOccured");
    }

    /**
     * Key {@code PostBuildScript.ExecutingPostBuildScripts}: {@code
     * Executing post build scripts.}.
     * 
     * @return
     *     {@code Executing post build scripts.}
     */
    public static String PostBuildScript_ExecutingPostBuildScripts() {
        return holder.format("PostBuildScript.ExecutingPostBuildScripts");
    }

    /**
     * Key {@code PostBuildScript.ExecutingPostBuildScripts}: {@code
     * Executing post build scripts.}.
     * 
     * @return
     *     {@code Executing post build scripts.}
     */
    public static Localizable _PostBuildScript_ExecutingPostBuildScripts() {
        return new Localizable(holder, "PostBuildScript.ExecutingPostBuildScripts");
    }

    /**
     * Key {@code PostBuildScript.NoFilePathProvided}: {@code No file path
     * provided for script file #{0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No file path provided for script file #{0}.}
     */
    public static String PostBuildScript_NoFilePathProvided(Object arg0) {
        return holder.format("PostBuildScript.NoFilePathProvided", arg0);
    }

    /**
     * Key {@code PostBuildScript.NoFilePathProvided}: {@code No file path
     * provided for script file #{0}.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No file path provided for script file #{0}.}
     */
    public static Localizable _PostBuildScript_NoFilePathProvided(Object arg0) {
        return new Localizable(holder, "PostBuildScript.NoFilePathProvided", arg0);
    }

}
