/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.postbuildscript;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.util.Collection;
import java.util.List;
import org.jenkinsci.plugins.postbuildscript.ConfigurableMatrixAggregator;
import org.jenkinsci.plugins.postbuildscript.Messages;
import org.jenkinsci.plugins.postbuildscript.model.Configuration;
import org.jenkinsci.plugins.postbuildscript.model.PostBuildStep;
import org.jenkinsci.plugins.postbuildscript.model.Script;
import org.jenkinsci.plugins.postbuildscript.model.ScriptFile;
import org.jenkinsci.plugins.postbuildscript.model.ScriptType;
import org.jenkinsci.plugins.postbuildscript.processor.Processor;
import org.jenkinsci.plugins.postbuildscript.processor.ProcessorFactory;
import org.kohsuke.stapler.DataBoundConstructor;

public class PostBuildScript
extends Notifier
implements MatrixAggregatable {
    private Configuration config = new Configuration();

    @DataBoundConstructor
    public PostBuildScript(Collection<ScriptFile> genericScriptFiles, Collection<ScriptFile> groovyScriptFiles, Collection<Script> groovyScripts, Collection<PostBuildStep> buildSteps, boolean markBuildUnstable) {
        this.addScriptFiles(genericScriptFiles, ScriptType.GENERIC);
        this.addScriptFiles(groovyScriptFiles, ScriptType.GROOVY);
        if (groovyScripts != null) {
            this.config.addGroovyScripts(groovyScripts);
        }
        if (buildSteps != null) {
            this.config.addBuildSteps(buildSteps);
        }
        this.config.setMarkBuildUnstable(markBuildUnstable);
    }

    void addScriptFiles(Collection<? extends ScriptFile> scriptFiles, ScriptType scriptType) {
        if (scriptFiles != null) {
            for (ScriptFile scriptFile : scriptFiles) {
                scriptFile.setScriptType(scriptType);
            }
            this.config.addScriptFiles(scriptFiles);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        Processor processor = this.createProcessor(build, launcher, listener);
        return processor.process();
    }

    ProcessorFactory createProcessorFactory() {
        return new ProcessorFactory(this.config);
    }

    public List<? extends ScriptFile> getGenericScriptFiles() {
        return this.config.getScriptFiles(ScriptType.GENERIC);
    }

    public List<? extends ScriptFile> getGroovyScriptFiles() {
        return this.config.getScriptFiles(ScriptType.GROOVY);
    }

    public List<? extends Script> getGroovyScripts() {
        return this.config.getGroovyScripts();
    }

    public List<PostBuildStep> getBuildSteps() {
        return this.config.getBuildSteps();
    }

    private Processor createProcessor(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        ProcessorFactory processorFactory = this.createProcessorFactory();
        return processorFactory.createMatrixProcessor(build, launcher, listener);
    }

    public boolean isMarkBuildUnstable() {
        return this.config.isMarkBuildUnstable();
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        ProcessorFactory processorFactory = this.createProcessorFactory();
        return new ConfigurableMatrixAggregator(build, launcher, listener, processorFactory, ((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return Messages.PostBuildScript_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/postbuildscript/help/postbuildscript.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

