/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollscm;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import jenkins.triggers.SCMTriggerItem;
import org.jenkinsci.plugins.pollscm.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class PollNowAction
implements Action {
    public static final Permission POLL = new Permission(Item.PERMISSIONS, "Poll", Messages._PollNowAction_PollPermission_Description(), Permission.UPDATE, PermissionScope.ITEM);
    private SCMTriggerItem target;

    public PollNowAction(SCMTriggerItem target) {
        this.target = target;
    }

    public Trigger getTrigger() {
        return this.target.getSCMTrigger();
    }

    public SCMTriggerItem getOwner() {
        return this.target;
    }

    public String getIconFileName() {
        return this.getACL().hasPermission(POLL) ? "symbol-play" : null;
    }

    private ACL getACL() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IllegalStateException("Jenkins is null");
        }
        return j.getACL();
    }

    public String getDisplayName() {
        return Messages.PollNowAction_PollNow();
    }

    public String getUrlName() {
        return "poll";
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    public void doPolling(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.getACL().checkPermission(POLL);
        Trigger trigger = this.getTrigger();
        if (trigger == null) {
            throw new IllegalStateException("Trigger is null");
        }
        trigger.run();
        rsp.sendRedirect(".");
    }

    @Extension
    public static class TransientProjectActionFactoryImpl
    extends TransientActionFactory<SCMTriggerItem> {
        public Collection<? extends Action> createFor(SCMTriggerItem target) {
            SCMTrigger trigger = target.getSCMTrigger();
            if (trigger != null) {
                return Collections.singleton(new PollNowAction(target));
            }
            return Collections.EMPTY_LIST;
        }

        public Class type() {
            return SCMTriggerItem.class;
        }
    }
}

