/*
 * Decompiled with CFR 0.152.
 */
package com.github.timothydowney.plugins.pipeline.npm;

import com.github.timothydowney.plugins.pipeline.npm.WithNPMStep;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Contextual fields used only in start(); no onResume needed")
class WithNPMStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(WithNPMStepExecution.class.getName());
    private final transient WithNPMStep step;
    private final transient TaskListener listener;
    private final transient FilePath ws;
    private final transient Launcher launcher;
    private transient EnvVars envOverride;
    private final transient Run<?, ?> build;
    private transient Computer computer;
    private transient BodyExecution body;
    private transient PrintStream console;

    WithNPMStepExecution(StepContext context, WithNPMStep step) throws Exception {
        super(context);
        this.step = step;
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.ws = (FilePath)context.get(FilePath.class);
        this.launcher = (Launcher)context.get(Launcher.class);
        this.build = (Run)context.get(Run.class);
    }

    public boolean start() throws Exception {
        this.envOverride = new EnvVars();
        this.console = this.listener.getLogger();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "npmrc Config: {0}", this.step.getNpmrcConfig());
        }
        this.getComputer();
        this.settingsFromConfig(this.step.getNpmrcConfig(), this.ws.child(".npmrc"));
        ConsoleLogFilter consFilter = (ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class);
        EnvironmentExpander envEx = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this.envOverride));
        this.body = this.getContext().newBodyInvoker().withContexts(new Object[]{envEx, consFilter}).withCallback((BodyExecutionCallback)new Callback()).start();
        return false;
    }

    private void settingsFromConfig(String settingsConfigId, FilePath settingsFile) throws AbortException {
        Config config = ConfigFiles.getByIdOrNull(this.build, (String)settingsConfigId);
        if (config == null) {
            throw new AbortException("Could not find the NPM config file id:" + settingsConfigId + ". Make sure it exists on Managed Files");
        }
        if (StringUtils.isBlank((CharSequence)config.content)) {
            throw new AbortException("Could not create NPM config file id:" + settingsConfigId + ". Content of the file is empty");
        }
        this.console.println("Using settings config with name " + config.name);
        try {
            if (settingsFile.exists()) {
                this.console.println("A workscape local .npmrc already exists and will be overwrriten for the build.");
            }
            ConfigProvider provider = config.getDescriptor();
            ArrayList tempFiles = new ArrayList();
            String fileContent = provider.supplyContent(config, this.build, this.ws, this.listener, tempFiles);
            this.console.println("Writing .npmrc file: " + String.valueOf(settingsFile));
            settingsFile.write(fileContent, this.getComputer().getDefaultCharset().name());
        }
        catch (Exception e) {
            throw new IllegalStateException("The npmrc could not be supplied for the current build: " + e.getMessage(), e);
        }
    }

    public void stop(Throwable cause) throws Exception {
        if (this.body != null) {
            this.body.cancel(cause);
        }
    }

    @NonNull
    private Computer getComputer() throws AbortException {
        if (this.computer != null) {
            return this.computer;
        }
        String node = null;
        Jenkins j = Jenkins.get();
        for (Computer c : j.getComputers()) {
            if (c.getChannel() != this.launcher.getChannel()) continue;
            node = c.getName();
            break;
        }
        if (node == null) {
            throw new AbortException("Could not find computer for the job");
        }
        this.computer = j.getComputer(node);
        if (this.computer == null) {
            throw new AbortException("No such computer " + node);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Computer: {0}", this.computer.getName());
            try {
                LOGGER.log(Level.FINE, "Env: {0}", this.computer.getEnvironment());
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return this.computer;
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, String> overrides;

        private ExpanderImpl(EnvVars overrides) {
            LOGGER.log(Level.FINE, "Overrides: " + overrides.toString());
            this.overrides = new HashMap<String, String>();
            for (Map.Entry entry : overrides.entrySet()) {
                this.overrides.put((String)entry.getKey(), (String)entry.getValue());
            }
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.overrides);
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;

        private Callback() {
        }

        protected void finished(StepContext context) throws Exception {
        }
    }
}

