/*
 * Decompiled with CFR 0.152.
 */
package com.github.timothydowney.plugins.pipeline.npm;

import com.github.timothydowney.plugins.pipeline.npm.WithNPMStepExecution;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.util.Set;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.custom.CustomConfig;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

@SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
public class WithNPMStep
extends Step {
    private String npmrcConfig;

    @DataBoundConstructor
    public WithNPMStep() {
    }

    public String getNpmrcConfig() {
        return this.npmrcConfig;
    }

    @DataBoundSetter
    public void setNpmrcConfig(String npmrcConfig) {
        this.npmrcConfig = npmrcConfig;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new WithNPMStepExecution(context, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withNPM";
        }

        public String getDisplayName() {
            return "Provide NPM environment";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, FilePath.class, Launcher.class, EnvVars.class, Run.class);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillNpmrcConfigItems(@AncestorInPath ItemGroup<?> context) {
            ListBoxModel r = new ListBoxModel();
            r.add("--- Choose an npmrc from custom config files ---", null);
            for (Config config : ConfigFiles.getConfigsInContext(context, CustomConfig.CustomConfigProvider.class)) {
                r.add(config.name, config.id);
            }
            return r;
        }
    }
}

