/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.milestone;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.CauseOfInterruption;
import org.jenkinsci.plugins.pipeline.milestone.CancelledCause;

public interface MilestoneStorage
extends ExtensionPoint {
    public static final Logger LOGGER = Logger.getLogger(MilestoneStorage.class.getName());

    public Map<Integer, Integer> store(@NonNull Run<?, ?> var1, @CheckForNull Integer var2);

    @NonNull
    public ClearResult clear(@NonNull Run<?, ?> var1);

    public void onDeletedJob(@NonNull Job<?, ?> var1);

    default public void cancel(Job<?, ?> job, int buildNumber, @NonNull String externalizableId) {
        Run run = job.getBuildByNumber(buildNumber);
        if (run == null) {
            LOGGER.fine(() -> job.getFullName() + "#" + buildNumber + " not found");
            return;
        }
        LOGGER.fine(() -> "Cancelling " + String.valueOf(run));
        Executor e = run.getExecutor();
        if (e != null) {
            e.interrupt(Result.NOT_BUILT, new CauseOfInterruption[]{new CancelledCause(externalizableId)});
        } else {
            LOGGER.warning(() -> "could not cancel an older flow because it has no assigned executor");
        }
    }

    public record ClearResult(Integer lastMilestoneBeforeCompletion, Map<Integer, Integer> milestones) {
    }
}

