/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.milestone;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.milestone.MilestoneStorage;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionListener;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.FlowScanningUtils;
import org.jenkinsci.plugins.workflow.graphanalysis.LinearScanner;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;

public class MilestoneStepExecution
extends SynchronousStepExecution<Void> {
    private static final Predicate<FlowNode> ORDINAL_MATCHER = FlowScanningUtils.hasActionPredicate(OrdinalAction.class);
    private static final Logger LOGGER = Logger.getLogger(MilestoneStepExecution.class.getName());
    private final String label;
    private final Integer ordinal;
    private final boolean unsafe;
    private static final long serialVersionUID = 1L;

    public MilestoneStepExecution(@NonNull StepContext context, @CheckForNull String label, @CheckForNull Integer ordinal, boolean unsafe) {
        super(context);
        this.label = label;
        this.ordinal = ordinal;
        this.unsafe = unsafe;
    }

    public static Map<Integer, Integer> getBuildsToCancel(int buildNumber, @CheckForNull Integer ordinal, @NonNull Map<Integer, Integer> milestones) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : milestones.entrySet()) {
            if (entry.getKey() < buildNumber) {
                if (entry.getValue() != null && (ordinal == null || entry.getValue() >= ordinal)) continue;
                Integer key = entry.getKey();
                result.put(key, buildNumber);
                continue;
            }
            if (entry.getKey() <= buildNumber || (ordinal != null || entry.getValue() == null) && (ordinal == null || entry.getValue() == null || entry.getValue() < ordinal)) continue;
            result.put(buildNumber, entry.getKey());
        }
        return result;
    }

    public Void run() throws Exception {
        if (this.label != null) {
            ((FlowNode)this.getContext().get(FlowNode.class)).addAction((Action)new LabelAction(this.label));
        }
        this.tryToPass((Run)this.getContext().get(Run.class), this.getContext(), this.processOrdinal());
        return null;
    }

    private synchronized int processOrdinal() throws IOException, InterruptedException {
        FlowNode node = (FlowNode)this.getContext().get(FlowNode.class);
        List heads = node.getExecution().getCurrentHeads();
        if (heads.size() > 1 && !this.unsafe) {
            throw new AbortException("Using a milestone step inside parallel is not allowed");
        }
        int nextOrdinal = this.getNextOrdinal(MilestoneStepExecution.getLatestOrdinalAction(heads));
        node.addAction((Action)new OrdinalAction(nextOrdinal));
        return nextOrdinal;
    }

    private static OrdinalAction getLatestOrdinalAction(List<FlowNode> heads) {
        FlowNode lastOrdinalNode = new LinearScanner().findFirstMatch(heads.get(0), ORDINAL_MATCHER);
        return lastOrdinalNode != null ? (OrdinalAction)lastOrdinalNode.getAction(OrdinalAction.class) : null;
    }

    private int getNextOrdinal(@CheckForNull OrdinalAction action) throws AbortException {
        Integer previousOrdinal = action != null ? Integer.valueOf(action.ordinal) : null;
        int nextOrdinal = 0;
        Integer stepOrdinal = this.ordinal;
        if (stepOrdinal != null) {
            if (previousOrdinal != null) {
                if (previousOrdinal >= stepOrdinal) {
                    throw new AbortException(String.format("Invalid ordinal %s, as the previous one was %s", stepOrdinal, previousOrdinal));
                }
                nextOrdinal = stepOrdinal;
            } else {
                nextOrdinal = stepOrdinal;
            }
        } else if (previousOrdinal != null) {
            nextOrdinal = previousOrdinal + 1;
        }
        return nextOrdinal;
    }

    private synchronized void tryToPass(Run<?, ?> r, StepContext context, int ordinal) {
        LOGGER.log(Level.FINE, () -> "build " + String.valueOf(r) + " trying to pass milestone " + ordinal);
        MilestoneStepExecution.println(context, "Trying to pass milestone " + ordinal);
        MilestoneStorage milestoneStorage = MilestoneStepExecution.getStorage();
        Map<Integer, Integer> milestones = milestoneStorage.store(r, ordinal);
        LOGGER.fine(() -> "build " + String.valueOf(r) + " : milestones after put -> " + String.valueOf(milestones));
        Map<Integer, Integer> buildsToCancel = MilestoneStepExecution.getBuildsToCancel(r.getNumber(), ordinal, milestones);
        MilestoneStepExecution.cancelAll(r.getParent(), buildsToCancel);
    }

    private static void cancelAll(Job<?, ?> job, Map<Integer, Integer> buildsToCancel) {
        LOGGER.fine(() -> "Cancelling " + String.valueOf(buildsToCancel));
        for (Map.Entry<Integer, Integer> buildEntry : buildsToCancel.entrySet()) {
            Integer referenceBuildNumber = buildEntry.getValue();
            Run referenceRun = job.getBuildByNumber(referenceBuildNumber.intValue());
            MilestoneStepExecution.getStorage().cancel(job, buildEntry.getKey(), (String)(referenceRun == null ? job.getFullName() + "#" + referenceBuildNumber : referenceRun.getExternalizableId()));
        }
    }

    private static void println(StepContext context, String message) {
        if (!context.isReady()) {
            LOGGER.log(Level.FINE, "cannot print message \u2018{0}\u2019 to dead {1}", new Object[]{message, context});
            return;
        }
        try {
            ((TaskListener)context.get(TaskListener.class)).getLogger().println(message);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, x, () -> "failed to print message to dead " + String.valueOf(context));
        }
    }

    @NonNull
    private static MilestoneStorage getStorage() {
        return (MilestoneStorage)ExtensionList.lookupFirst(MilestoneStorage.class);
    }

    private static class OrdinalAction
    extends InvisibleAction {
        int ordinal;

        public OrdinalAction(int ordinal) {
            this.ordinal = ordinal;
        }
    }

    @Extension
    public static final class FlowExecutionListenerImpl
    extends FlowExecutionListener {
        public void onResumed(@NonNull FlowExecution execution) {
            try {
                LOGGER.finest(() -> "Resuming " + String.valueOf(execution));
                Queue.Executable executable = execution.getOwner().getExecutable();
                if (executable instanceof Run) {
                    Run run = (Run)executable;
                    LOGGER.fine(() -> "Executable " + String.valueOf(executable) + " is a run");
                    OrdinalAction ordinalAction = MilestoneStepExecution.getLatestOrdinalAction(execution.getCurrentHeads());
                    MilestoneStorage milestoneStorage = MilestoneStepExecution.getStorage();
                    milestoneStorage.store(run, ordinalAction == null ? null : Integer.valueOf(ordinalAction.ordinal));
                } else {
                    LOGGER.fine(() -> "Executable " + String.valueOf(executable) + " is not a run");
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, () -> "Unable to look up executable from " + String.valueOf(execution));
            }
        }
    }

    @Extension
    public static final class ItemListenerImpl
    extends ItemListener {
        public void onDeleted(Item item) {
            if (item instanceof Job) {
                Job job = (Job)item;
                MilestoneStepExecution.getStorage().onDeletedJob(job);
            }
        }
    }

    @Extension
    public static final class Listener
    extends RunListener<Run<?, ?>> {
        public void onStarted(Run<?, ?> r, TaskListener listener) {
            if (this.isPipelineRun(r)) {
                MilestoneStorage milestoneStorage = MilestoneStepExecution.getStorage();
                milestoneStorage.store(r, null);
            }
        }

        public void onCompleted(Run<?, ?> r, @NonNull TaskListener listener) {
            if (this.isPipelineRun(r)) {
                MilestoneStorage milestoneStorage = MilestoneStepExecution.getStorage();
                MilestoneStorage.ClearResult result = milestoneStorage.clear(r);
                LOGGER.finest(() -> "milestones after completion: " + String.valueOf(result.milestones()));
                if (result.lastMilestoneBeforeCompletion() != null) {
                    LOGGER.finest(() -> "Build" + String.valueOf(r) + " last milestone before completion: " + result.lastMilestoneBeforeCompletion());
                    Map<Integer, Integer> buildsToCancel = MilestoneStepExecution.getBuildsToCancel(r.getNumber(), result.lastMilestoneBeforeCompletion() + 1, result.milestones());
                    MilestoneStepExecution.cancelAll(r.getParent(), buildsToCancel);
                } else {
                    LOGGER.finest(() -> "Build " + String.valueOf(r) + " was not using milestones, nothing to cancel");
                }
            }
        }

        private boolean isPipelineRun(Run<?, ?> r) {
            FlowExecutionOwner.Executable executable;
            return r instanceof FlowExecutionOwner.Executable && (executable = (FlowExecutionOwner.Executable)r).asFlowExecutionOwner() != null;
        }
    }
}

