/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.milestone;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Run;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.milestone.Milestone;
import org.jenkinsci.plugins.pipeline.milestone.MilestoneStepExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MilestoneStep
extends Step {
    private static final Logger LOGGER = Logger.getLogger(MilestoneStep.class.getName());
    @CheckForNull
    private String label;
    @CheckForNull
    private final Integer ordinal;
    private boolean unsafe;

    @DataBoundConstructor
    public MilestoneStep(@CheckForNull Integer ordinal) {
        this.ordinal = ordinal;
    }

    @DataBoundSetter
    public void setLabel(String label) {
        this.label = Util.fixEmpty((String)label);
    }

    @DataBoundSetter
    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    @CheckForNull
    public String getLabel() {
        return this.label;
    }

    @CheckForNull
    public Integer getOrdinal() {
        return this.ordinal;
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new MilestoneStepExecution(context, this.label, this.ordinal, this.unsafe);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        @Deprecated
        private transient Map<String, Map<Integer, Milestone>> milestonesByOrdinalByJob;

        public DescriptorImpl() {
            this.load();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(FlowNode.class, Run.class);
        }

        public String getFunctionName() {
            return "milestone";
        }

        @NonNull
        public String getDisplayName() {
            return "The milestone step forces all builds to go through in order";
        }

        public void load() {
            super.load();
            if (this.milestonesByOrdinalByJob == null) {
                this.milestonesByOrdinalByJob = new TreeMap<String, Map<Integer, Milestone>>();
            }
            LOGGER.log(Level.FINE, "load: {0}", this.milestonesByOrdinalByJob);
        }

        public void save() {
            super.save();
            LOGGER.log(Level.FINE, "save: {0}", this.milestonesByOrdinalByJob);
        }

        @Deprecated
        public Map<String, Map<Integer, Milestone>> getMilestonesByOrdinalByJob() {
            return this.milestonesByOrdinalByJob;
        }
    }
}

