/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokerStartExecutionHandler
extends AbstractExecutionHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public InvokerStartExecutionHandler(MavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    @Nullable
    protected ExecutionEvent.Type getSupportedType() {
        return ExecutionEvent.Type.MojoStarted;
    }

    @Override
    @Nullable
    protected String getSupportedPluginGoal() {
        return "org.apache.maven.plugins:maven-invoker-plugin:run";
    }

    @Override
    @NonNull
    protected List<String> getConfigurationParametersToReport(ExecutionEvent executionEvent) {
        return new ArrayList<String>();
    }

    @Override
    public boolean _handle(ExecutionEvent executionEvent) {
        boolean result = super._handle(executionEvent);
        this.logger.debug("[jenkins-event-spy] Start of goal " + this.getSupportedPluginGoal() + ", disabling spy in IT tests.");
        Xpp3Dom env = executionEvent.getMojoExecution().getConfiguration().getChild("environmentVariables");
        if (env == null) {
            env = new Xpp3Dom("environmentVariables");
            executionEvent.getMojoExecution().getConfiguration().addChild(env);
        }
        Xpp3Dom disableSpy = new Xpp3Dom("JENKINS_MAVEN_AGENT_DISABLED");
        disableSpy.setValue("true");
        env.addChild(disableSpy);
        return result;
    }
}

