/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractMavenEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.FileMavenEventReporter;
import org.sonatype.aether.RepositoryEvent;

public class RepositoryEventHandler
extends AbstractMavenEventHandler<RepositoryEvent> {
    long currentEventStartTimeInNanos;
    long artifactDownloadDurationInNanos;

    protected RepositoryEventHandler(FileMavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    protected boolean _handle(RepositoryEvent repositoryEvent) {
        long durationInNanos;
        if (repositoryEvent.getType() == RepositoryEvent.EventType.ARTIFACT_DOWNLOADING) {
            this.currentEventStartTimeInNanos = System.nanoTime();
        } else if (repositoryEvent.getType() == RepositoryEvent.EventType.ARTIFACT_DOWNLOADED) {
            durationInNanos = System.nanoTime() - this.currentEventStartTimeInNanos;
            this.artifactDownloadDurationInNanos += durationInNanos;
            this.print(repositoryEvent, durationInNanos);
            this.currentEventStartTimeInNanos = 0L;
        }
        if (repositoryEvent.getType() == RepositoryEvent.EventType.METADATA_DOWNLOADING) {
            this.currentEventStartTimeInNanos = System.nanoTime();
        } else if (repositoryEvent.getType() == RepositoryEvent.EventType.METADATA_DOWNLOADED) {
            durationInNanos = System.nanoTime() - this.currentEventStartTimeInNanos;
            this.artifactDownloadDurationInNanos += durationInNanos;
            this.print(repositoryEvent, durationInNanos);
            this.currentEventStartTimeInNanos = 0L;
        }
        return true;
    }

    private void print(RepositoryEvent repositoryEvent, long durationInNanos) {
        this.reporter.print(repositoryEvent.getArtifact().toString() + "-" + repositoryEvent.getType() + "-" + durationInNanos + "nanos");
    }
}

