/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.RuntimeIOException;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;

public class ProjectSucceededExecutionHandler
extends AbstractExecutionHandler {
    public ProjectSucceededExecutionHandler(MavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    protected ExecutionEvent.Type getSupportedType() {
        return ExecutionEvent.Type.ProjectSucceeded;
    }

    @Override
    protected void addDetails(ExecutionEvent executionEvent, Xpp3Dom element) {
        super.addDetails(executionEvent, element);
        MavenProject project = executionEvent.getProject();
        Artifact artifact = project.getArtifact();
        if (artifact != null) {
            Xpp3Dom artifactElt = this.newElement("artifact", artifact);
            File file = artifact.getFile();
            try {
                artifactElt.addChild(this.newElement("file", file == null ? null : file.getCanonicalPath()));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            element.addChild(artifactElt);
        }
        Xpp3Dom attachedArtifactsElt = new Xpp3Dom("attachedArtifacts");
        element.addChild(attachedArtifactsElt);
        for (Artifact attachedArtifact : project.getAttachedArtifacts()) {
            Xpp3Dom artifactElt = this.newElement("artifact", attachedArtifact);
            File file = attachedArtifact.getFile();
            try {
                artifactElt.addChild(this.newElement("file", file == null ? null : file.getCanonicalPath()));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            attachedArtifactsElt.addChild(artifactElt);
        }
    }

    @Override
    protected List<String> getConfigurationParametersToReport(ExecutionEvent executionEvent) {
        return Collections.emptyList();
    }
}

