/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.project.DependencyResolutionResult;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractMavenEventHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;

public class DependencyResolutionResultHandler
extends AbstractMavenEventHandler<DependencyResolutionResult> {
    private Set<String> includedScopes = new HashSet<String>(Arrays.asList("compile", "provided", "test"));
    private boolean includeSnapshots = true;
    private boolean includeReleases = true;

    public DependencyResolutionResultHandler(MavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    protected boolean _handle(DependencyResolutionResult result) {
        Xpp3Dom root = new Xpp3Dom("DependencyResolutionResult");
        root.setAttribute("class", result.getClass().getName());
        Xpp3Dom dependenciesElt = new Xpp3Dom("resolvedDependencies");
        root.addChild(dependenciesElt);
        for (Dependency dependency : result.getResolvedDependencies()) {
            Artifact artifact = dependency.getArtifact();
            if (!this.includedScopes.contains(dependency.getScope()) || !this.includeSnapshots && artifact.isSnapshot() || !this.includeReleases && !artifact.isSnapshot()) continue;
            Xpp3Dom dependencyElt = new Xpp3Dom("dependency");
            dependencyElt.addChild(this.newElement("file", artifact.getFile().getAbsolutePath()));
            dependencyElt.setAttribute("name", artifact.getFile().getName());
            dependencyElt.setAttribute("groupId", artifact.getGroupId());
            dependencyElt.setAttribute("artifactId", artifact.getArtifactId());
            dependencyElt.setAttribute("version", artifact.getVersion());
            dependencyElt.setAttribute("baseVersion", artifact.getBaseVersion());
            if (artifact.getClassifier() != null) {
                dependencyElt.setAttribute("classifier", artifact.getClassifier());
            }
            dependencyElt.setAttribute("type", artifact.getExtension());
            dependencyElt.setAttribute("id", artifact.getArtifactId());
            dependencyElt.setAttribute("extension", artifact.getExtension());
            dependencyElt.setAttribute("scope", dependency.getScope());
            dependencyElt.setAttribute("optional", Boolean.toString(dependency.isOptional()));
            dependencyElt.setAttribute("snapshot", Boolean.toString(artifact.isSnapshot()));
            dependenciesElt.addChild(dependencyElt);
        }
        this.reporter.print(root);
        return true;
    }
}

