/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.eventspy.handler;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jenkinsci.plugins.pipeline.maven.eventspy.handler.AbstractExecutionHandler;
import org.jenkinsci.plugins.pipeline.maven.eventspy.reporter.MavenEventReporter;

public class ProjectStartedExecutionHandler
extends AbstractExecutionHandler {
    public ProjectStartedExecutionHandler(MavenEventReporter reporter) {
        super(reporter);
    }

    @Override
    protected ExecutionEvent.Type getSupportedType() {
        return ExecutionEvent.Type.ProjectStarted;
    }

    @Override
    protected List<String> getConfigurationParametersToReport(ExecutionEvent executionEvent) {
        return Collections.emptyList();
    }

    @Override
    public boolean _handle(@NonNull ExecutionEvent executionEvent) {
        return super._handle(executionEvent);
    }

    @Override
    protected void addDetails(@NonNull ExecutionEvent executionEvent, @NonNull Xpp3Dom root) {
        super.addDetails(executionEvent, root);
        MavenProject parentProject = executionEvent.getProject().getParent();
        if (parentProject != null) {
            Xpp3Dom parentProjectElt = new Xpp3Dom("parentProject");
            root.addChild(parentProjectElt);
            parentProjectElt.setAttribute("name", parentProject.getName());
            parentProjectElt.setAttribute("groupId", parentProject.getGroupId());
            parentProjectElt.setAttribute("artifactId", parentProject.getArtifactId());
            parentProjectElt.setAttribute("version", parentProject.getVersion());
        }
    }
}

