ALTER TABLE JENKINS_JOB ADD LAST_BUILD_NUMBER integer;
ALTER TABLE JENKINS_JOB ADD LAST_SUCCESSFUL_BUILD_NUMBER integer;

CREATE TABLE JENKINS_BUILD_RESULT
(
  NAME varchar(256) NOT NULL,
  ID integer PRIMARY KEY NOT NULL,
  COMPLETE boolean
);

INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (0, 'SUCCESS', true);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (1, 'UNSTABLE', true);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (2, 'FAILURE', true);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (3, 'NOT_BUILT', false);
INSERT INTO JENKINS_BUILD_RESULT (ID, NAME, COMPLETE) VALUES (4, 'ABORTED', false);

ALTER TABLE JENKINS_BUILD ADD RESULT_ID integer;

ALTER TABLE JENKINS_BUILD ADD FOREIGN KEY (RESULT_ID) REFERENCES JENKINS_BUILD_RESULT (ID);

ALTER TABLE JENKINS_BUILD ADD START_TIME timestamp;
ALTER TABLE JENKINS_BUILD ADD DURATION_IN_MILLIS integer;

UPDATE VERSION SET VERSION = 10;
