// CHECKSTYLE:OFF

package org.jenkinsci.plugins.pipeline.maven.db;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code dao.mysql.description}: {@code Pipeline Maven Plugin

     * storage using MySql}.
     * 
     * @return
     *     {@code Pipeline Maven Plugin storage using MySql}
     */
    public static String dao_mysql_description() {
        return holder.format("dao.mysql.description");
    }

    /**
     * Key {@code dao.mysql.description}: {@code Pipeline Maven Plugin

     * storage using MySql}.
     * 
     * @return
     *     {@code Pipeline Maven Plugin storage using MySql}
     */
    public static Localizable _dao_mysql_description() {
        return new Localizable(holder, "dao.mysql.description");
    }

    /**
     * Key {@code dao.h2.description}: {@code Pipeline Maven Plugin storage

     * using H2}.
     * 
     * @return
     *     {@code Pipeline Maven Plugin storage using H2}
     */
    public static String dao_h2_description() {
        return holder.format("dao.h2.description");
    }

    /**
     * Key {@code dao.h2.description}: {@code Pipeline Maven Plugin storage

     * using H2}.
     * 
     * @return
     *     {@code Pipeline Maven Plugin storage using H2}
     */
    public static Localizable _dao_h2_description() {
        return new Localizable(holder, "dao.h2.description");
    }

    /**
     * Key {@code dao.postgesql.description}: {@code Pipeline Maven Plugin

     * storage using Postgres}.
     * 
     * @return
     *     {@code Pipeline Maven Plugin storage using Postgres}
     */
    public static String dao_postgesql_description() {
        return holder.format("dao.postgesql.description");
    }

    /**
     * Key {@code dao.postgesql.description}: {@code Pipeline Maven Plugin

     * storage using Postgres}.
     * 
     * @return
     *     {@code Pipeline Maven Plugin storage using Postgres}
     */
    public static Localizable _dao_postgesql_description() {
        return new Localizable(holder, "dao.postgesql.description");
    }

}
