CREATE OR REPLACE VIEW "JOB_GENERATED_ARTIFACTS" as
  select
    JENKINS_JOB.FULL_NAME as JOB_FULL_NAME, JENKINS_BUILD.NUMBER AS BUILD_NUMBER,
    GENERATED_MAVEN_ARTIFACT.VERSION as GENERATED_MAVEN_ARTIFACT_VERSION, GENERATED_MAVEN_ARTIFACT.SKIP_DOWNSTREAM_TRIGGERS, GENERATED_MAVEN_ARTIFACT.REPOSITORY_URL, GENERATED_MAVEN_ARTIFACT.EXTENSION,
    MAVEN_ARTIFACT.GROUP_ID, MAVEN_ARTIFACT.ARTIFACT_ID, MAVEN_ARTIFACT.VERSION, MAVEN_ARTIFACT.TYPE, MAVEN_ARTIFACT.CLASSIFIER, MAVEN_ARTIFACT.ID
  from MAVEN_ARTIFACT inner join GENERATED_MAVEN_ARTIFACT on MAVEN_ARTIFACT.ID = GENERATED_MAVEN_ARTIFACT.ARTIFACT_ID
    inner join JENKINS_BUILD on GENERATED_MAVEN_ARTIFACT.BUILD_ID = JENKINS_BUILD.ID
    inner join JENKINS_JOB on JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID;

CREATE OR REPLACE VIEW "JOB_DEPENDENCIES" as
  select
    JENKINS_JOB.FULL_NAME as JOB_FULL_NAME, JENKINS_BUILD.NUMBER AS BUILD_NUMBER,
    MAVEN_DEPENDENCY.SCOPE, MAVEN_DEPENDENCY.IGNORE_UPSTREAM_TRIGGERS,
    MAVEN_ARTIFACT.GROUP_ID, MAVEN_ARTIFACT.ARTIFACT_ID, MAVEN_ARTIFACT.VERSION, MAVEN_ARTIFACT.TYPE, MAVEN_ARTIFACT.CLASSIFIER, MAVEN_ARTIFACT.ID
  from MAVEN_ARTIFACT inner join MAVEN_DEPENDENCY on MAVEN_ARTIFACT.ID = MAVEN_DEPENDENCY.ARTIFACT_ID
    inner join JENKINS_BUILD on MAVEN_DEPENDENCY.BUILD_ID = JENKINS_BUILD.ID
    inner join JENKINS_JOB on JENKINS_BUILD.JOB_ID = JENKINS_JOB.ID;

UPDATE VERSION SET VERSION = 7;
