/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.maven.dao;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.pipeline.maven.dao.AbstractPipelineMavenPluginDaoDecorator;
import org.jenkinsci.plugins.pipeline.maven.dao.PipelineMavenPluginDao;

public class CustomTypePipelineMavenPluginDaoDecorator
extends AbstractPipelineMavenPluginDaoDecorator {
    private static final List<String> KNOWN_JAR_TYPES_WITH_DIFFERENT_EXTENSION = Arrays.asList("test-jar", "maven-plugin", "ejb", "ejb-client", "java-source", "javadoc");
    private final Logger LOGGER = Logger.getLogger(this.getClass().getName());

    public CustomTypePipelineMavenPluginDaoDecorator(@NonNull PipelineMavenPluginDao delegate) {
        super(delegate);
    }

    @Override
    public void recordGeneratedArtifact(@NonNull String jobFullName, int buildNumber, @NonNull String groupId, @NonNull String artifactId, @NonNull String version, @NonNull String type, @NonNull String baseVersion, @Nullable String repositoryUrl, boolean skipDownstreamTriggers, String extension, String classifier) {
        super.recordGeneratedArtifact(jobFullName, buildNumber, groupId, artifactId, version, type, baseVersion, repositoryUrl, skipDownstreamTriggers, extension, classifier);
        if (this.shouldReportAgainWithExtensionAsType(type, extension)) {
            this.LOGGER.log(Level.FINE, "Recording generated artifact " + groupId + ":" + artifactId + ":" + version + " as " + extension + " (in addition to " + type + ")");
            super.recordGeneratedArtifact(jobFullName, buildNumber, groupId, artifactId, version, extension, baseVersion, repositoryUrl, skipDownstreamTriggers, extension, classifier);
        }
    }

    private boolean shouldReportAgainWithExtensionAsType(String type, String extension) {
        if (KNOWN_JAR_TYPES_WITH_DIFFERENT_EXTENSION.contains(type)) {
            return false;
        }
        return type != null && !type.equals(extension);
    }
}

