/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.client;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Team;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitComment;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedGitHubClient;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedMergeStatus;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedPullRequest;
import org.jenkinsci.plugins.pipeline.github.client.Review;

public class ExtendedPullRequestService
extends PullRequestService {
    public ExtendedPullRequestService(ExtendedGitHubClient client) {
        super((GitHubClient)client);
    }

    public ExtendedGitHubClient getClient() {
        return (ExtendedGitHubClient)super.getClient();
    }

    public ExtendedPullRequest editPullRequest(IRepositoryIdProvider repository, ExtendedPullRequest request) {
        Objects.requireNonNull(request, "request cannot be null");
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/pulls");
        uri.append('/').append(request.getNumber());
        Map<String, Object> params = this.editPrMap(request);
        return (ExtendedPullRequest)((Object)this.getClient().patch(uri.toString(), params, (Type)((Object)ExtendedPullRequest.class)));
    }

    protected Map<String, Object> editPrMap(ExtendedPullRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (request.getTitle() != null) {
            params.put("title", request.getTitle());
        }
        if (request.getBody() != null) {
            params.put("body", request.getBody());
        }
        if (request.getState() != null) {
            params.put("state", request.getState());
        }
        if (request.getBase() != null) {
            params.put("base", request.getBase().getRef());
        }
        if (request.isMaintainerCanModify() != null) {
            params.put("maintainer_can_modify", request.isMaintainerCanModify());
        }
        return params;
    }

    public ExtendedPullRequest getPullRequest(IRepositoryIdProvider repository, int id) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType(ExtendedPullRequest.class);
        return (ExtendedPullRequest)((Object)this.getClient().getUnchecked(request).getBody());
    }

    public ExtendedPullRequest getMergedPullRequest(IRepositoryIdProvider repository, String mergeCommitSha, String targetBranch) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("?state=").append("closed");
        uri.append("&sort=").append("updated");
        uri.append("&direction=").append("desc");
        uri.append("&per_page=").append("10");
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<ExtendedPullRequest>>(){}.getType());
        List pullRequests = (List)this.getClient().getUnchecked(request).getBody();
        if (pullRequests != null) {
            for (ExtendedPullRequest pr : pullRequests) {
                if (pr.getMergeCommitSha() == null || !pr.getMergeCommitSha().equals(mergeCommitSha) || null != targetBranch && !pr.getBase().getRef().equals(targetBranch)) continue;
                return pr;
            }
        }
        return null;
    }

    public ExtendedMergeStatus merge(IRepositoryIdProvider repository, int id, String commitTitle, String commitMessage, String sha, String mergeMethod) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/merge");
        HashMap<String, String> params = new HashMap<String, String>();
        if (commitTitle != null) {
            params.put("commit_title", commitTitle);
        }
        if (commitMessage != null) {
            params.put("commit_message", commitMessage);
        }
        if (sha != null) {
            params.put("sha", sha);
        }
        if (mergeMethod != null) {
            params.put("merge_method", mergeMethod);
        }
        return (ExtendedMergeStatus)((Object)this.getClient().put(uri.toString(), params, (Type)((Object)ExtendedMergeStatus.class)));
    }

    public PageIterator<ExtendedCommitComment> pageComments2(IRepositoryIdProvider repository, int id) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest(1, 100);
        request.setUri(uri);
        request.setType(new TypeToken<List<ExtendedCommitComment>>(){}.getType());
        return this.createPageIterator(request);
    }

    public ExtendedCommitComment createComment2(IRepositoryIdProvider repository, int id, ExtendedCommitComment comment) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/comments");
        return (ExtendedCommitComment)((Object)this.client.post(uri.toString(), (Object)comment, ExtendedCommitComment.class));
    }

    public ExtendedCommitComment replyToComment2(IRepositoryIdProvider repository, int pullRequestId, int commentId, String body) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(pullRequestId);
        uri.append("/comments");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("in_reply_to", Integer.toString(commentId));
        params.put("body", body);
        return (ExtendedCommitComment)((Object)this.client.post(uri.toString(), params, ExtendedCommitComment.class));
    }

    public ExtendedCommitComment editComment2(IRepositoryIdProvider repository, ExtendedCommitComment comment) throws IOException {
        Objects.requireNonNull(comment, "comment cannot be null");
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (ExtendedCommitComment)((Object)this.client.post(uri.toString(), (Object)comment, ExtendedCommitComment.class));
    }

    public PageIterator<User> pageRequestedReviewers(IRepositoryIdProvider repository, int id) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/requested_reviewers");
        PagedRequest request = this.createPagedRequest(1, 100);
        request.setUri(uri);
        request.setType(new TypeToken<List<User>>(){}.getType());
        return this.createPageIterator(request);
    }

    public PageIterator<Team> pageRequestedTeamReviewers(IRepositoryIdProvider repository, int id) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/requested_reviewers");
        PagedRequest request = this.createPagedRequest(1, 100);
        request.setUri(uri);
        request.setType(new TypeToken<List<Team>>(){}.getType());
        return this.createPageIterator(request);
    }

    public PageIterator<Review> pageReviews(IRepositoryIdProvider repository, int id) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/reviews");
        PagedRequest request = this.createPagedRequest(1, 100);
        request.setUri(uri);
        request.setType(new TypeToken<List<Review>>(){}.getType());
        return this.createPageIterator(request);
    }

    public void createReview(IRepositoryIdProvider repository, int id, String commitId, String event, String body) throws IOException {
        if (event != null && (event.equals("REQUEST_CHANGES") || event.equals("COMMENT"))) {
            Objects.requireNonNull(body, "body is a required argument when event equals REQUEST_CHANGES or COMMENT");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/reviews");
        HashMap<String, String> params = new HashMap<String, String>();
        if (commitId != null) {
            params.put("commit_id", commitId);
        }
        if (body != null) {
            params.put("body", body);
        }
        if (event != null) {
            params.put("event", event);
        }
        this.getClient().post(uri.toString(), params, null);
    }

    public void createReviewRequests(IRepositoryIdProvider repository, int id, List<String> reviewers, List<String> teamReviewers) throws IOException {
        if (Objects.isNull(reviewers) && Objects.isNull(teamReviewers)) {
            throw new IllegalArgumentException("Either reviewers or teamReviewers must be non-null");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/requested_reviewers");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (!Objects.isNull(reviewers)) {
            params.put("reviewers", reviewers);
        }
        if (!Objects.isNull(teamReviewers)) {
            params.put("team_reviewers", teamReviewers);
        }
        this.getClient().post(uri.toString(), params, (Type)((Object)ExtendedPullRequest.class));
    }

    public void deleteReviewRequests(IRepositoryIdProvider repository, int id, List<String> reviewers, List<String> teamReviewers) throws IOException {
        if (Objects.isNull(reviewers) && Objects.isNull(teamReviewers)) {
            throw new IllegalArgumentException("Either reviewers or teamReviewers must be non-null");
        }
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/pulls");
        uri.append('/').append(id);
        uri.append("/requested_reviewers");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (!Objects.isNull(reviewers)) {
            params.put("reviewers", reviewers);
        }
        if (!Objects.isNull(teamReviewers)) {
            params.put("team_reviewers", teamReviewers);
        }
        this.getClient().delete(uri.toString(), params);
    }

    public void deleteBranch(IRepositoryIdProvider repository, String branchReference) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/git");
        uri.append("/refs");
        uri.append("/heads");
        uri.append('/');
        uri.append(branchReference);
        this.getClient().delete(uri.toString());
    }
}

