/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.trigger;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github.extension.GHSubscriberEvent;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.pipeline.github.GitHubHelper;
import org.jenkinsci.plugins.pipeline.github.trigger.GitHubEnvironmentVariablesAction;
import org.jenkinsci.plugins.pipeline.github.trigger.IssueCommentCause;
import org.jenkinsci.plugins.pipeline.github.trigger.IssueCommentTrigger;
import org.jenkinsci.plugins.pipeline.github.trigger.LabelAddedCause;
import org.jenkinsci.plugins.pipeline.github.trigger.LabelAddedTrigger;
import org.jenkinsci.plugins.pipeline.github.trigger.PullRequestReviewCause;
import org.jenkinsci.plugins.pipeline.github.trigger.PullRequestReviewTrigger;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPullRequestReview;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubEventSubscriber
extends GHEventsSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(GHEventsSubscriber.class);

    protected boolean isApplicable(@Nullable Item project) {
        if (project != null) {
            SCMSourceOwner owner;
            if (project instanceof SCMSourceOwner) {
                owner = (SCMSourceOwner)project;
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return true;
                }
            }
            if (project.getParent() instanceof SCMSourceOwner) {
                owner = (SCMSourceOwner)project.getParent();
                for (SCMSource source : owner.getSCMSources()) {
                    if (!(source instanceof GitHubSCMSource)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected void onEvent(GHSubscriberEvent event) {
        LOG.debug("Received event: {}", (Object)event.getGHEvent());
        switch (event.getGHEvent()) {
            case ISSUE_COMMENT: {
                this.handleIssueComment(event);
                break;
            }
            case PULL_REQUEST: {
                this.handleLabelEvent(event);
                break;
            }
            case PULL_REQUEST_REVIEW: {
                this.handlePullRequestReview(event);
                break;
            }
        }
    }

    private void handleLabelEvent(GHSubscriberEvent event) {
        GHEventPayload.PullRequest prEvent;
        switch (event.getType()) {
            case CREATED: 
            case UPDATED: {
                break;
            }
            default: {
                return;
            }
        }
        try {
            prEvent = (GHEventPayload.PullRequest)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.PullRequest.class);
        }
        catch (IOException e) {
            LOG.error("Unable to parse the payload of GHSubscriberEvent: {}", (Object)event, (Object)e);
            return;
        }
        switch (prEvent.getAction()) {
            case "labeled": {
                break;
            }
            default: {
                LOG.debug("Ignoring PR: {} event with Action: {}", (Object)prEvent.getNumber(), (Object)prEvent.getAction());
                return;
            }
        }
        String key = String.format("%s/%s/%d", prEvent.getRepository().getOwnerName(), prEvent.getRepository().getName(), prEvent.getNumber());
        LabelAddedTrigger.DescriptorImpl triggerDescriptor = (LabelAddedTrigger.DescriptorImpl)Jenkins.get().getDescriptor(LabelAddedTrigger.class);
        if (triggerDescriptor == null) {
            LOG.error("Unable to find the LabelAddedTrigger Trigger, this shouldn't happen.");
            return;
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        String labelName = prEvent.getLabel().getName();
        LOG.info("Added label {} to repo {}", (Object)labelName, (Object)key);
        values.add((ParameterValue)new StringParameterValue("GITHUB_LABEL_ADDED", String.valueOf(labelName)));
        for (WorkflowJob job : triggerDescriptor.getJobs(key)) {
            List matchingTriggers = job.getTriggersJobProperty().getTriggers().stream().filter(LabelAddedTrigger.class::isInstance).map(LabelAddedTrigger.class::cast).filter(labelTrigger -> this.labelAddedMatches((LabelAddedTrigger)((Object)labelTrigger), labelName, job)).collect(Collectors.toList());
            if (matchingTriggers.size() == 0) {
                LOG.debug("No labels match the ones attached to the trigger");
                break;
            }
            job.scheduleBuild2(Jenkins.getInstance().getQuietPeriod(), new Action[]{new CauseAction((Cause)new LabelAddedCause(prEvent.getSender().getLogin(), labelName)), new GitHubEnvironmentVariablesAction(values)});
        }
    }

    private boolean labelAddedMatches(LabelAddedTrigger trigger, String labelName, WorkflowJob job) {
        boolean matches = trigger.matchesLabel(labelName);
        if (matches) {
            LOG.debug("Job: {}, labelName: {}, the label did matched the triggerLabel: {}", new Object[]{job.getFullName(), labelName, trigger.getLabelTrigger()});
            return true;
        }
        LOG.debug("Job: {}, labelName: {}, the label did not matched the triggerLabel: {}", new Object[]{job.getFullName(), labelName, trigger.getLabelTrigger()});
        return false;
    }

    private void handleIssueComment(GHSubscriberEvent event) {
        GHEventPayload.IssueComment issueCommentEvent;
        switch (event.getType()) {
            case CREATED: 
            case UPDATED: {
                break;
            }
            default: {
                return;
            }
        }
        try {
            issueCommentEvent = (GHEventPayload.IssueComment)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.IssueComment.class);
        }
        catch (IOException e) {
            LOG.error("Unable to parse the payload of GHSubscriberEvent: {}", (Object)event, (Object)e);
            return;
        }
        switch (issueCommentEvent.getAction()) {
            case "created": 
            case "edited": {
                break;
            }
            default: {
                LOG.debug("Ignoring IssueComment: {} with Action: {}", (Object)issueCommentEvent.getComment(), (Object)issueCommentEvent.getAction());
                return;
            }
        }
        String key = String.format("%s/%s/%d", issueCommentEvent.getRepository().getOwnerName(), issueCommentEvent.getRepository().getName(), issueCommentEvent.getIssue().getNumber());
        IssueCommentTrigger.DescriptorImpl triggerDescriptor = (IssueCommentTrigger.DescriptorImpl)Jenkins.get().getDescriptor(IssueCommentTrigger.class);
        if (triggerDescriptor == null) {
            LOG.error("Unable to find the IssueComment Trigger, this shouldn't happen.");
            return;
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        values.add((ParameterValue)new StringParameterValue("GITHUB_COMMENT", String.valueOf(issueCommentEvent.getComment().getBody())));
        values.add((ParameterValue)new StringParameterValue("GITHUB_COMMENT_AUTHOR", String.valueOf(issueCommentEvent.getComment().getUserName())));
        for (WorkflowJob job : triggerDescriptor.getJobs(key)) {
            List matchingTriggers = job.getTriggersJobProperty().getTriggers().stream().filter(IssueCommentTrigger.class::isInstance).map(IssueCommentTrigger.class::cast).filter(t -> this.commentTriggerMatches((IssueCommentTrigger)((Object)t), issueCommentEvent.getComment(), job)).collect(Collectors.toList());
            for (IssueCommentTrigger matchingTrigger : matchingTriggers) {
                String commentAuthor = issueCommentEvent.getComment().getUserName();
                boolean authorized = this.isAuthorized(job, commentAuthor);
                if (authorized) {
                    job.scheduleBuild2(Jenkins.getInstance().getQuietPeriod(), new Action[]{new CauseAction((Cause)new IssueCommentCause(issueCommentEvent.getComment().getUserName(), issueCommentEvent.getComment().getBody(), matchingTrigger.getCommentPattern())), new GitHubEnvironmentVariablesAction(values)});
                    LOG.info("Job: {} triggered by IssueComment: {}", (Object)job.getFullName(), (Object)issueCommentEvent.getComment());
                    continue;
                }
                LOG.warn("Job: {}, IssueComment: {}, Comment Author: {} is not a collaborator, and is therefore not authorized to trigger a build.", new Object[]{job.getFullName(), issueCommentEvent.getComment(), commentAuthor});
            }
        }
    }

    private boolean isAuthorized(WorkflowJob job, String commentAuthor) {
        return GitHubHelper.isAuthorized(job, commentAuthor);
    }

    private boolean commentTriggerMatches(IssueCommentTrigger trigger, GHIssueComment issueComment, WorkflowJob job) {
        if (trigger.matchesComment(issueComment.getBody())) {
            LOG.debug("Job: {}, IssueComment: {} matched Pattern: {}", new Object[]{job.getFullName(), issueComment, trigger.getCommentPattern()});
            return true;
        }
        LOG.debug("Job: {}, IssueComment: {}, the comment did not match Pattern: {}", new Object[]{job.getFullName(), issueComment, trigger.getCommentPattern()});
        return false;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private void handlePullRequestReview(GHSubscriberEvent event) {
        GHEventPayload.PullRequestReview pullRequestReview;
        switch (event.getType()) {
            case CREATED: 
            case UPDATED: {
                break;
            }
            default: {
                return;
            }
        }
        try {
            pullRequestReview = (GHEventPayload.PullRequestReview)GitHub.offline().parseEventPayload((Reader)new StringReader((String)event.getPayload()), GHEventPayload.PullRequestReview.class);
        }
        catch (IOException e) {
            LOG.error("Unable to parse the payload of GHSubscriberEvent: {}", (Object)event, (Object)e);
            return;
        }
        switch (pullRequestReview.getAction()) {
            case "submitted": {
                break;
            }
            default: {
                LOG.debug("Ignoring pullRequestReview: {} with Action: {}", (Object)pullRequestReview.getReview(), (Object)pullRequestReview.getAction());
                return;
            }
        }
        String key = String.format("%s/%s/%d", pullRequestReview.getRepository().getOwnerName(), pullRequestReview.getRepository().getName(), pullRequestReview.getPullRequest().getNumber());
        PullRequestReviewTrigger.DescriptorImpl triggerDescriptor = (PullRequestReviewTrigger.DescriptorImpl)Jenkins.get().getDescriptor(PullRequestReviewTrigger.class);
        if (triggerDescriptor == null) {
            LOG.error("Unable to find the PullRequestReview Trigger, this shouldn't happen.");
            return;
        }
        String reviewer = pullRequestReview.getSender().getLogin();
        ArrayList<ParameterValue> reviewEnvVars = new ArrayList<ParameterValue>();
        reviewEnvVars.add((ParameterValue)new StringParameterValue("GITHUB_REVIEW_COMMENT", String.valueOf(pullRequestReview.getReview().getBody())));
        reviewEnvVars.add((ParameterValue)new StringParameterValue("GITHUB_REVIEW_AUTHOR", reviewer));
        reviewEnvVars.add((ParameterValue)new StringParameterValue("GITHUB_REVIEW_STATE", pullRequestReview.getReview().getState().name()));
        for (WorkflowJob job : triggerDescriptor.getJobs(key)) {
            List matchingTriggers = job.getTriggersJobProperty().getTriggers().stream().filter(PullRequestReviewTrigger.class::isInstance).map(PullRequestReviewTrigger.class::cast).filter(t -> this.commentTriggerMatches((PullRequestReviewTrigger)((Object)t), pullRequestReview.getReview(), job)).collect(Collectors.toList());
            for (PullRequestReviewTrigger matchingTrigger : matchingTriggers) {
                boolean authorized = this.isAuthorized(job, reviewer);
                if (authorized) {
                    job.scheduleBuild2(Jenkins.get().getQuietPeriod(), new Action[]{new CauseAction((Cause)new PullRequestReviewCause(reviewer, pullRequestReview.getReview().getState().name().toLowerCase(), pullRequestReview.getReview().getBody(), matchingTrigger.getReviewStates())), new GitHubEnvironmentVariablesAction(reviewEnvVars)});
                    LOG.info("Job: {} triggered by PullRequestReview: {}", (Object)job.getFullName(), (Object)pullRequestReview.getReview());
                    continue;
                }
                LOG.warn("Job: {}, PullRequestReview: {}, Reviewer: {} is not a collaborator, and is therefore not authorized to trigger a build.", new Object[]{job.getFullName(), pullRequestReview.getReview(), reviewer});
            }
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private boolean commentTriggerMatches(PullRequestReviewTrigger trigger, GHPullRequestReview review, WorkflowJob job) {
        if (trigger.matches(review.getState().name().toLowerCase())) {
            LOG.debug("Job: {}, PullRequestReview: {} matched one of the states: {}", new Object[]{job.getFullName(), review, trigger.getReviewStates()});
            return true;
        }
        LOG.debug("Job: {}, PullRequestReview: {}, state did not match the states: {}", new Object[]{job.getFullName(), review, trigger.getReviewStates()});
        return false;
    }

    protected Set<GHEvent> events() {
        HashSet<GHEvent> events = new HashSet<GHEvent>();
        events.add(GHEvent.ISSUE_COMMENT);
        events.add(GHEvent.PULL_REQUEST);
        events.add(GHEvent.PULL_REQUEST_REVIEW);
        return Collections.unmodifiableSet(events);
    }
}

