/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.client;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.CommitService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitComment;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedGitHubClient;

public class ExtendedCommitService
extends CommitService {
    public ExtendedCommitService(ExtendedGitHubClient client) {
        super((GitHubClient)client);
    }

    public ExtendedGitHubClient getClient() {
        return (ExtendedGitHubClient)super.getClient();
    }

    public ExtendedCommitComment addComment(IRepositoryIdProvider repository, String sha, ExtendedCommitComment comment) throws IOException {
        Objects.requireNonNull(sha, "sha cannot be null");
        if (sha.isEmpty()) {
            throw new IllegalArgumentException("sha cannot be empty");
        }
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        return (ExtendedCommitComment)((Object)this.getClient().post(uri.toString(), (Object)comment, (Type)((Object)ExtendedCommitComment.class)));
    }

    public ExtendedCommitComment replyToComment(IRepositoryIdProvider repository, String sha, int commentId, String body) throws IOException {
        Objects.requireNonNull(sha, "sha cannot be null");
        if (sha.isEmpty()) {
            throw new IllegalArgumentException("Sha cannot be empty");
        }
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("in_reply_to", Integer.toString(commentId));
        params.put("body", body);
        return (ExtendedCommitComment)((Object)this.getClient().post(uri.toString(), params, (Type)((Object)ExtendedCommitComment.class)));
    }

    public ExtendedCommitComment editComment2(IRepositoryIdProvider repository, ExtendedCommitComment comment) throws IOException {
        Objects.requireNonNull(comment, "comment cannot be null");
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/comments");
        uri.append('/').append(comment.getId());
        return (ExtendedCommitComment)((Object)this.client.post(uri.toString(), (Object)comment, ExtendedCommitComment.class));
    }

    public PageIterator<ExtendedCommitComment> pageComments2(IRepositoryIdProvider repository, String sha) {
        return this.pageComments2(repository, sha, 100);
    }

    public PageIterator<ExtendedCommitComment> pageComments2(IRepositoryIdProvider repository, String sha, int size) {
        return this.pageComments2(repository, sha, 1, size);
    }

    public PageIterator<ExtendedCommitComment> pageComments2(IRepositoryIdProvider repository, String sha, int start, int size) {
        Objects.requireNonNull(sha, "sha cannot be null");
        if (sha.isEmpty()) {
            throw new IllegalArgumentException("sha cannot be empty");
        }
        String id = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/commits");
        uri.append('/').append(sha);
        uri.append("/comments");
        PagedRequest request = this.createPagedRequest(start, size);
        request.setUri(uri);
        request.setType(new TypeToken<List<ExtendedCommitComment>>(){}.getType());
        return this.createPageIterator(request);
    }
}

