/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Run;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.jenkinsci.plugins.github_branch_source.BranchSCMHead;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.pipeline.github.DetectMergedPullRequestTrait;
import org.jenkinsci.plugins.pipeline.github.MergedPullRequestGlobalVariable;
import org.jenkinsci.plugins.pipeline.github.PullRequestGlobalVariable;
import org.jenkinsci.plugins.workflow.cps.GlobalVariable;
import org.jenkinsci.plugins.workflow.cps.GlobalVariableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class GitHubPipelineGlobalVariables
extends GlobalVariableSet {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubPipelineGlobalVariables.class);

    @NonNull
    public Collection<GlobalVariable> forRun(Run<?, ?> run) {
        if (run == null) {
            return Collections.emptyList();
        }
        SCMHead scmHead = SCMHead.HeadByItem.findHead((Item)run.getParent());
        if (scmHead instanceof PullRequestSCMHead) {
            LinkedList<GlobalVariable> result = new LinkedList<GlobalVariable>();
            result.add(new PullRequestGlobalVariable());
            if (this.shouldDetectMergedPullRequest(run)) {
                result.add(new MergedPullRequestGlobalVariable());
            }
            return result;
        }
        if (scmHead instanceof BranchSCMHead && this.shouldDetectMergedPullRequest(run)) {
            LinkedList<GlobalVariable> result = new LinkedList<GlobalVariable>();
            result.add(new MergedPullRequestGlobalVariable());
            return result;
        }
        return Collections.emptyList();
    }

    private boolean shouldDetectMergedPullRequest(Run<?, ?> run) {
        SCMSource scmSource = SCMSource.SourceByItem.findSource((Item)run.getParent());
        if (null != scmSource && scmSource instanceof GitHubSCMSource) {
            GitHubSCMSource gitHubSource = (GitHubSCMSource)scmSource;
            List traits = gitHubSource.getTraits();
            for (SCMSourceTrait trait : traits) {
                if (!(trait instanceof DetectMergedPullRequestTrait)) continue;
                LOG.debug("{} found for run: {}", trait.getClass(), (Object)run.getFullDisplayName());
                return true;
            }
        }
        return false;
    }
}

