/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.GitHubResponse;

public class ExtendedGitHubClient
extends GitHubClient {
    public ExtendedGitHubClient() {
    }

    public ExtendedGitHubClient(String hostname) {
        super(hostname);
    }

    public ExtendedGitHubClient(String hostname, int port, String scheme) {
        super(hostname, port, scheme);
    }

    public <V> V patch(String uri, Object params, Type type) {
        return this.patch(uri, params, type, null);
    }

    public <V> V patch(String uri, Object params, Type type, String accept) {
        try {
            HttpURLConnection request = this.createPost(uri);
            request.setRequestProperty("X-HTTP-Method-Override", "PATCH");
            if (accept != null) {
                request.setRequestProperty("Accept", accept);
            }
            return this.sendJson(request, params, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <V> V post(String uri, Object params, Type type, String accept) throws IOException {
        HttpURLConnection request = this.createPost(uri);
        if (accept != null) {
            request.setRequestProperty("Accept", accept);
        }
        return this.sendJson(request, params, type);
    }

    public <V> V put(String uri, Object params, Type type, String accept) throws IOException {
        HttpURLConnection request = this.createPut(uri);
        if (accept != null) {
            request.setRequestProperty("Accept", accept);
        }
        return this.sendJson(request, params, type);
    }

    private <V> V sendJson(HttpURLConnection request, Object params, Type type) throws IOException {
        this.sendParams(request, params);
        int code = request.getResponseCode();
        this.updateRateLimits(request);
        if (this.isOk(code)) {
            return (V)(type != null ? this.parseJson(this.getStream(request), type) : null);
        }
        if (this.isEmpty(code)) {
            return null;
        }
        throw this.createException(this.getStream(request), code, request.getResponseMessage());
    }

    public GitHubResponse getUnchecked(GitHubRequest request) {
        try {
            return this.get(request);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <V> V delete(String uri, Type type, String accept) throws IOException {
        HttpURLConnection request = this.createDelete(uri);
        if (accept != null) {
            request.setRequestProperty("Accept", accept);
        }
        int code = request.getResponseCode();
        this.updateRateLimits(request);
        if (this.isOk(code)) {
            return (V)(type != null ? this.parseJson(this.getStream(request), type) : null);
        }
        if (this.isEmpty(code)) {
            return null;
        }
        throw this.createException(this.getStream(request), code, request.getResponseMessage());
    }
}

