/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyObjectSupport;
import hudson.model.Job;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jenkins.model.Jenkins;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.CommitStatus;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.PullRequestMarker;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.Team;
import org.eclipse.egit.github.core.User;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.pipeline.github.CommitFileGroovyObject;
import org.jenkinsci.plugins.pipeline.github.CommitGroovyObject;
import org.jenkinsci.plugins.pipeline.github.CommitStatusGroovyObject;
import org.jenkinsci.plugins.pipeline.github.GitHubHelper;
import org.jenkinsci.plugins.pipeline.github.IssueCommentGroovyObject;
import org.jenkinsci.plugins.pipeline.github.MilestoneGroovyObject;
import org.jenkinsci.plugins.pipeline.github.ReviewCommentGroovyObject;
import org.jenkinsci.plugins.pipeline.github.ReviewGroovyObject;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitComment;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedGitHubClient;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedIssueService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedMergeStatus;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedMilestone;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedMilestoneService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedPullRequest;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedPullRequestService;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class PullRequestGroovyObject
extends GroovyObjectSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final PullRequestSCMHead pullRequestHead;
    private final RepositoryId base;
    private final RepositoryId head;
    private ExtendedPullRequest pullRequest;
    private transient Job job;
    private transient ExtendedGitHubClient gitHubClient;
    private transient ExtendedPullRequestService pullRequestService;
    private transient ExtendedIssueService issueService;
    private transient ExtendedCommitService commitService;
    private transient ExtendedMilestoneService milestoneService;

    PullRequestGroovyObject(@NonNull Job job) throws Exception {
        this.job = job;
        this.jobId = job.getFullName();
        this.pullRequestHead = GitHubHelper.getPullRequest(job);
        this.base = GitHubHelper.getRepositoryId(job);
        this.head = RepositoryId.create((String)this.pullRequestHead.getSourceOwner(), (String)this.pullRequestHead.getSourceRepo());
        this.pullRequest = this.getPullRequestService().getPullRequest((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber());
    }

    private Job getJob() {
        if (this.job == null) {
            this.job = (Job)Jenkins.get().getItemByFullName(this.jobId, Job.class);
            if (this.job == null) {
                throw new IllegalStateException("Unable to find Job: " + this.jobId);
            }
        }
        return this.job;
    }

    private ExtendedGitHubClient getGitHubClient() {
        if (this.gitHubClient == null) {
            this.gitHubClient = GitHubHelper.getGitHubClient(this.getJob());
        }
        return this.gitHubClient;
    }

    private ExtendedPullRequestService getPullRequestService() {
        if (this.pullRequestService == null) {
            this.pullRequestService = new ExtendedPullRequestService(this.getGitHubClient());
        }
        return this.pullRequestService;
    }

    private ExtendedIssueService getIssueService() {
        if (this.issueService == null) {
            this.issueService = new ExtendedIssueService(this.getGitHubClient());
        }
        return this.issueService;
    }

    private ExtendedCommitService getCommitService() {
        if (this.commitService == null) {
            this.commitService = new ExtendedCommitService(this.getGitHubClient());
        }
        return this.commitService;
    }

    private ExtendedMilestoneService getMilestoneService() {
        if (this.milestoneService == null) {
            this.milestoneService = new ExtendedMilestoneService(this.getGitHubClient());
        }
        return this.milestoneService;
    }

    @Whitelisted
    public long getId() {
        return this.pullRequest.getId();
    }

    @Whitelisted
    public int getNumber() {
        return this.pullRequest.getNumber();
    }

    @Whitelisted
    public String getDiffUrl() {
        return this.pullRequest.getDiffUrl();
    }

    @Whitelisted
    public String getUrl() {
        return this.pullRequest.getHtmlUrl();
    }

    @Whitelisted
    public String getPatchUrl() {
        return this.pullRequest.getPatchUrl();
    }

    @Whitelisted
    public String getState() {
        return this.pullRequest.getState();
    }

    @Whitelisted
    public String getIssueUrl() {
        return this.pullRequest.getIssueUrl();
    }

    @Whitelisted
    public String getTitle() {
        return this.pullRequest.getTitle();
    }

    @Whitelisted
    public String getBody() {
        return this.pullRequest.getBody();
    }

    @Whitelisted
    public boolean isLocked() {
        return this.pullRequest.isLocked();
    }

    @Whitelisted
    public boolean isDraft() {
        return this.pullRequest.isDraft();
    }

    @Whitelisted
    public MilestoneGroovyObject getMilestone() {
        return Optional.ofNullable(this.pullRequest.getMilestone()).map(Milestone::getNumber).map(m -> this.getMilestoneService().getMilestone((IRepositoryIdProvider)this.base, (int)m)).map(milestone -> new MilestoneGroovyObject(this.jobId, (ExtendedMilestone)((Object)milestone))).orElse(null);
    }

    @Whitelisted
    public String getHead() {
        return this.pullRequest.getHead().getSha();
    }

    @Whitelisted
    public String getHeadRef() {
        return this.pullRequest.getHead().getRef();
    }

    @Whitelisted
    public String getBaseSha() {
        return this.pullRequest.getBase().getSha();
    }

    @Whitelisted
    public String getBase() {
        return this.pullRequest.getBase().getRef();
    }

    @Whitelisted
    public Date getUpdatedAt() {
        return this.pullRequest.getUpdatedAt();
    }

    @Whitelisted
    public Date getCreatedAt() {
        return this.pullRequest.getCreatedAt();
    }

    @Whitelisted
    public String getCreatedBy() {
        return GitHubHelper.userToLogin(this.pullRequest.getUser());
    }

    @Whitelisted
    public Date getClosedAt() {
        return this.pullRequest.getCreatedAt();
    }

    @Whitelisted
    public String getClosedBy() {
        return GitHubHelper.userToLogin(this.pullRequest.getClosedBy());
    }

    @Whitelisted
    public Date getMergedAt() {
        return this.pullRequest.getMergedAt();
    }

    @Whitelisted
    public String getMergedBy() {
        return GitHubHelper.userToLogin(this.pullRequest.getMergedBy());
    }

    @Whitelisted
    public int getCommitCount() {
        return this.pullRequest.getCommits();
    }

    @Whitelisted
    public int getCommentCount() {
        return this.pullRequest.getComments();
    }

    @Whitelisted
    public int getDeletions() {
        return this.pullRequest.getDeletions();
    }

    @Whitelisted
    public String getMergeCommitSha() {
        return this.pullRequest.getMergeCommitSha();
    }

    @Whitelisted
    public String getMergeableState() {
        return this.pullRequest.getMergeableState();
    }

    @Whitelisted
    public boolean isMaintainerCanModify() {
        return this.pullRequest.isMaintainerCanModify();
    }

    @Whitelisted
    public int getAdditions() {
        return this.pullRequest.getAdditions();
    }

    @Whitelisted
    public int getChangedFiles() {
        return this.pullRequest.getChangedFiles();
    }

    @Whitelisted
    public boolean isMergeable() {
        return this.pullRequest.isMergeable();
    }

    @Whitelisted
    public boolean isMerged() {
        return this.pullRequest.isMerged();
    }

    @Whitelisted
    public Iterable<String> getRequestedReviewers() {
        Stream<String> stream = StreamSupport.stream(this.getPullRequestService().pageRequestedReviewers((IRepositoryIdProvider)this.base, this.pullRequest.getNumber()).spliterator(), false).flatMap(Collection::stream).map(User::getLogin);
        return stream::iterator;
    }

    @Whitelisted
    public Iterable<String> getRequestedTeamReviewers() {
        Stream<String> stream = StreamSupport.stream(this.getPullRequestService().pageRequestedTeamReviewers((IRepositoryIdProvider)this.base, this.pullRequest.getNumber()).spliterator(), false).flatMap(Collection::stream).map(Team::getName);
        return stream::iterator;
    }

    @Whitelisted
    public Iterable<ReviewGroovyObject> getReviews() {
        Stream<ReviewGroovyObject> stream = StreamSupport.stream(this.getPullRequestService().pageReviews((IRepositoryIdProvider)this.base, this.pullRequest.getNumber()).spliterator(), false).flatMap(Collection::stream).map(ReviewGroovyObject::new);
        return stream::iterator;
    }

    @Whitelisted
    public Iterable<CommitStatusGroovyObject> getStatuses() {
        try {
            return this.getCommitService().getStatuses((IRepositoryIdProvider)this.base, this.pullRequest.getHead().getSha()).stream().map(CommitStatusGroovyObject::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public Iterable<String> getLabels() {
        Stream<String> stream = StreamSupport.stream(this.getIssueService().getLabels((IRepositoryIdProvider)this.base, this.pullRequest.getNumber()).spliterator(), false).flatMap(Collection::stream).map(Label::getName);
        return stream::iterator;
    }

    @Whitelisted
    public Iterable<String> getAssignees() {
        return this.pullRequest.getAssignees().stream().map(User::getLogin).collect(Collectors.toList());
    }

    @Whitelisted
    public Iterable<CommitGroovyObject> getCommits() {
        try {
            Stream<CommitGroovyObject> steam = this.getPullRequestService().getCommits((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber()).stream().map(c -> new CommitGroovyObject(this.jobId, (RepositoryCommit)c, this.getCommitService(), this.base));
            return steam::iterator;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public Iterable<IssueCommentGroovyObject> getComments() {
        try {
            Stream<IssueCommentGroovyObject> stream = this.getIssueService().getComments((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber()).stream().map(c -> new IssueCommentGroovyObject(this.jobId, (Comment)c, this.base, this.getIssueService()));
            return stream::iterator;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public Iterable<ReviewCommentGroovyObject> getReviewComments() {
        Stream<ReviewCommentGroovyObject> stream = StreamSupport.stream(this.getPullRequestService().pageComments2((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber()).spliterator(), false).flatMap(Collection::stream).map(c -> new ReviewCommentGroovyObject(this.jobId, this.base, (ExtendedCommitComment)((Object)c), this.getCommitService()));
        return stream::iterator;
    }

    @Whitelisted
    public Iterable<CommitFileGroovyObject> getFiles() {
        try {
            return this.getPullRequestService().getFiles((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber()).stream().map(CommitFileGroovyObject::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void setMilestone(int milestoneNumber) {
        this.pullRequest.setMilestone(this.getIssueService().setMilestone((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), milestoneNumber).getMilestone());
    }

    @Whitelisted
    public void setMilestone(MilestoneGroovyObject milestone) {
        if (milestone == null) {
            this.pullRequest.setMilestone(this.getIssueService().setMilestone((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), null).getMilestone());
        } else {
            this.setMilestone(milestone.getNumber());
        }
    }

    @Whitelisted
    public void setLocked(boolean locked) {
        try {
            if (locked) {
                this.getIssueService().lockIssue((IRepositoryIdProvider)this.base, this.pullRequest.getNumber());
            } else {
                this.getIssueService().unlockIssue((IRepositoryIdProvider)this.base, this.pullRequest.getNumber());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void setTitle(String title) {
        Objects.requireNonNull(title, "title cannot be null");
        ExtendedPullRequest edit = new ExtendedPullRequest();
        edit.setNumber(this.pullRequest.getNumber());
        edit.setTitle(title);
        this.pullRequest = this.getPullRequestService().editPullRequest((IRepositoryIdProvider)this.base, edit);
    }

    @Whitelisted
    public void setBody(String body) {
        Objects.requireNonNull(body, "body cannot be null");
        ExtendedPullRequest edit = new ExtendedPullRequest();
        edit.setNumber(this.pullRequest.getNumber());
        edit.setBody(body);
        this.pullRequest = this.getPullRequestService().editPullRequest((IRepositoryIdProvider)this.base, edit);
    }

    @Whitelisted
    public void setState(String state) {
        Objects.requireNonNull(state, "state cannot be null");
        ExtendedPullRequest edit = new ExtendedPullRequest();
        edit.setNumber(this.pullRequest.getNumber());
        edit.setState(state);
        this.pullRequest = this.getPullRequestService().editPullRequest((IRepositoryIdProvider)this.base, edit);
    }

    @Whitelisted
    public void setBase(String newBase) {
        Objects.requireNonNull(newBase, "base cannot be null");
        ExtendedPullRequest edit = new ExtendedPullRequest();
        edit.setNumber(this.pullRequest.getNumber());
        edit.setBase(new PullRequestMarker().setRef(newBase));
        this.pullRequest = this.getPullRequestService().editPullRequest((IRepositoryIdProvider)this.base, edit);
    }

    @Whitelisted
    public void setMaintainerCanModify(boolean value) {
        ExtendedPullRequest edit = new ExtendedPullRequest();
        edit.setNumber(this.pullRequest.getNumber());
        edit.setMaintainerCanModify(value);
        this.pullRequest = this.getPullRequestService().editPullRequest((IRepositoryIdProvider)this.base, edit);
    }

    @Whitelisted
    public void setLabels(List<String> labels) {
        try {
            this.getIssueService().setLabels((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), Optional.ofNullable(labels).orElseGet(Collections::emptyList));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void createReviewRequest(String reviewer) {
        Objects.requireNonNull(reviewer, "reviewer cannot be null");
        this.createReviewRequests(Collections.singletonList(reviewer));
    }

    @Whitelisted
    public void createReviewRequests(List<String> reviewers) {
        Objects.requireNonNull(reviewers, "reviewers cannot be null");
        try {
            this.getPullRequestService().createReviewRequests((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), reviewers, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void deleteReviewRequest(String reviewer) {
        Objects.requireNonNull(reviewer, "reviewer cannot be null");
        this.deleteReviewRequests(Collections.singletonList(reviewer));
    }

    @Whitelisted
    public void deleteReviewRequests(List<String> reviewers) {
        Objects.requireNonNull(reviewers, "reviewers cannot be null");
        try {
            this.getPullRequestService().deleteReviewRequests((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), reviewers, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void createTeamReviewRequest(String team) {
        Objects.requireNonNull(team, "team cannot be null");
        this.createTeamReviewRequests(Collections.singletonList(team));
    }

    @Whitelisted
    public void createTeamReviewRequests(List<String> teams) {
        Objects.requireNonNull(teams, "teams cannot be null");
        try {
            this.getPullRequestService().createReviewRequests((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), null, teams);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void deleteTeamReviewRequest(String team) {
        Objects.requireNonNull(team, "team cannot be null");
        this.deleteTeamReviewRequests(Collections.singletonList(team));
    }

    @Whitelisted
    public void deleteTeamReviewRequests(List<String> teams) {
        Objects.requireNonNull(teams, "teams cannot be null");
        try {
            this.getPullRequestService().deleteReviewRequests((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), null, teams);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void addLabel(String label) {
        this.addLabels(Collections.singletonList(label));
    }

    @Whitelisted
    public void addLabels(List<String> labels) {
        Objects.requireNonNull(labels, "labels is a required argument");
        try {
            this.getIssueService().addLabels((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), labels);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void removeLabel(String label) {
        Objects.requireNonNull(label, "label is a required argument");
        try {
            this.getIssueService().removeLabel((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), label);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void addAssignees(List<String> assignees) {
        Objects.requireNonNull(assignees, "assignees is a required argument");
        try {
            this.getIssueService().addAssignees((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), assignees);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void setAssignees(List<String> assignees) {
        Objects.requireNonNull(assignees, "assignees is a required argument");
        try {
            this.getIssueService().setAssignees((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), assignees);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void removeAssignees(List<String> assignees) {
        Objects.requireNonNull(assignees, "assignees is a required argument");
        try {
            this.getIssueService().removeAssignees((IRepositoryIdProvider)this.base, this.pullRequest.getNumber(), assignees);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void review(String event) {
        this.review(null, event, null);
    }

    @Whitelisted
    public void review(String event, String body) {
        this.review(null, event, body);
    }

    @Whitelisted
    public void review(Map<String, Object> params) {
        this.review(params.get("commitId") != null ? params.get("commitId").toString() : null, params.get("event") != null ? params.get("event").toString() : null, params.get("body") != null ? params.get("body").toString() : null);
    }

    @Whitelisted
    public void review(String commitId, String event, String body) {
        if (event != null && (event.equals("REQUEST_CHANGES") || event.equals("COMMENT"))) {
            Objects.requireNonNull(body, "body is a required argument when event equals REQUEST_CHANGES or COMMENT");
        }
        try {
            this.pullRequestService.createReview((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber(), commitId, event, body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public CommitStatusGroovyObject createStatus(Map<String, Object> params) {
        Objects.requireNonNull(params.get("status"), "status is a required argument");
        return this.createStatus(params.get("status").toString(), params.get("context") != null ? params.get("context").toString() : null, params.get("description") != null ? params.get("description").toString() : null, params.get("targetUrl") != null ? params.get("targetUrl").toString() : null);
    }

    @Whitelisted
    public CommitStatusGroovyObject createStatus(String status, String context, String description, String targetUrl) {
        Objects.requireNonNull(status, "status is a required argument");
        CommitStatus commitStatus = new CommitStatus();
        commitStatus.setState(status);
        commitStatus.setContext(context);
        commitStatus.setDescription(description);
        commitStatus.setTargetUrl(targetUrl);
        try {
            return new CommitStatusGroovyObject(this.getCommitService().createStatus((IRepositoryIdProvider)this.base, this.pullRequest.getHead().getSha(), commitStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public ReviewCommentGroovyObject reviewComment(String commitId, String path, int line, String body) {
        Objects.requireNonNull(commitId, "commitId is a required argument");
        Objects.requireNonNull(path, "path is a required argument");
        Objects.requireNonNull(body, "body is a required argument");
        ExtendedCommitComment comment = new ExtendedCommitComment();
        comment.setCommitId(commitId);
        comment.setPath(path);
        comment.setLine(line);
        comment.setBody(body);
        try {
            return new ReviewCommentGroovyObject(this.jobId, this.base, this.getPullRequestService().createComment2((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber(), comment), this.getCommitService());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public ReviewCommentGroovyObject replyToReviewComment(long commentId, String body) {
        Objects.requireNonNull(body, "body is a required argument");
        try {
            return new ReviewCommentGroovyObject(this.jobId, this.base, this.getPullRequestService().replyToComment2((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber(), (int)commentId, body), this.getCommitService());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void deleteReviewComment(long commentId) {
        try {
            this.getPullRequestService().deleteComment((IRepositoryIdProvider)this.base, commentId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public ReviewCommentGroovyObject editReviewComment(long commentId, String body) {
        Objects.requireNonNull(body, "body is a required argument");
        ExtendedCommitComment comment = new ExtendedCommitComment();
        comment.setId(commentId);
        comment.setBody(body);
        try {
            return new ReviewCommentGroovyObject(this.jobId, this.base, this.getPullRequestService().editComment2((IRepositoryIdProvider)this.base, comment), this.getCommitService());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public IssueCommentGroovyObject comment(String body) {
        Objects.requireNonNull(body, "body is a required argument");
        try {
            return new IssueCommentGroovyObject(this.jobId, this.getIssueService().createComment((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber(), body), this.base, this.getIssueService());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public IssueCommentGroovyObject editComment(long commentId, String body) {
        Objects.requireNonNull(body, "body is a required argument");
        Comment comment = new Comment();
        comment.setId(commentId);
        comment.setBody(body);
        try {
            return new IssueCommentGroovyObject(this.jobId, this.getIssueService().editComment((IRepositoryIdProvider)this.base, comment), this.base, this.getIssueService());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void deleteComment(long commentId) {
        try {
            this.getIssueService().deleteComment((IRepositoryIdProvider)this.base, commentId);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public String merge(Map<String, Object> params) {
        return this.merge(Optional.ofNullable(params.get("commitTitle")).map(Object::toString).orElse(null), Optional.ofNullable(params.get("commitMessage")).map(Object::toString).orElse(null), Optional.ofNullable(params.get("sha")).map(Object::toString).orElse(null), Optional.ofNullable(params.get("mergeMethod")).map(Object::toString).orElse(null));
    }

    @Whitelisted
    public String merge(String commitMessage) {
        return this.merge(null, commitMessage, null, null);
    }

    @Whitelisted
    public String merge(String commitTitle, String commitMessage, String sha, String mergeMethod) {
        try {
            ExtendedMergeStatus status = this.getPullRequestService().merge((IRepositoryIdProvider)this.base, this.pullRequestHead.getNumber(), commitTitle, commitMessage, sha, mergeMethod);
            if (status.isMerged()) {
                return status.getSha();
            }
            throw new RuntimeException(status.getMessage());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void refresh() {
        this.pullRequest = this.getPullRequestService().getPullRequest((IRepositoryIdProvider)this.base, this.pullRequest.getNumber());
    }

    @Whitelisted
    public void setCredentials(String userName, String password) {
        this.getGitHubClient().setCredentials(userName, password);
    }

    @Whitelisted
    public void deleteBranch() {
        try {
            this.getPullRequestService().deleteBranch((IRepositoryIdProvider)this.base, this.pullRequest.getBranchReference());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

