/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Date;
import java.util.Objects;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.IssueService;
import org.jenkinsci.plugins.pipeline.github.GitHubHelper;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class IssueCommentGroovyObject
extends GroovyObjectSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final RepositoryId base;
    private Comment comment;
    private transient IssueService issueService;

    IssueCommentGroovyObject(String jobId, Comment comment, RepositoryId base, IssueService issueService) {
        this.jobId = Objects.requireNonNull(jobId, "jobId cannot be null");
        this.comment = Objects.requireNonNull(comment, "comment cannot be null");
        this.base = Objects.requireNonNull(base, "base cannot be null");
        this.issueService = Objects.requireNonNull(issueService, "issueService cannot be null");
    }

    private IssueService getIssueService() {
        if (this.issueService == null) {
            this.issueService = new IssueService((GitHubClient)GitHubHelper.getGitHubClient(GitHubHelper.getJob(this.jobId)));
        }
        return this.issueService;
    }

    @Whitelisted
    public Date getCreatedAt() {
        return this.comment.getCreatedAt();
    }

    @Whitelisted
    public Date getUpdatedAt() {
        return this.comment.getUpdatedAt();
    }

    @Whitelisted
    public String getBody() {
        return this.comment.getBody();
    }

    @Whitelisted
    public String getBodyHtml() {
        return this.comment.getBodyHtml();
    }

    @Whitelisted
    public String getBodyText() {
        return this.comment.getBodyText();
    }

    @Whitelisted
    public long getId() {
        return this.comment.getId();
    }

    @Whitelisted
    public String getUrl() {
        return this.comment.getUrl();
    }

    @Whitelisted
    public String getUser() {
        return GitHubHelper.userToLogin(this.comment.getUser());
    }

    @Whitelisted
    public void setBody(String body) {
        Comment edit = new Comment();
        edit.setId(this.comment.getId());
        edit.setBody(body);
        try {
            this.comment = this.getIssueService().editComment((IRepositoryIdProvider)this.base, edit);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void delete() {
        try {
            this.getIssueService().deleteComment((IRepositoryIdProvider)this.base, this.comment.getId());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

