/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestReviewTrigger
extends Trigger<WorkflowJob> {
    private static final Logger LOG = LoggerFactory.getLogger(PullRequestReviewTrigger.class);
    private String[] reviewStates = null;

    @DataBoundConstructor
    public PullRequestReviewTrigger() {
    }

    public String[] getReviewStates() {
        return Arrays.copyOf(this.reviewStates, this.reviewStates.length);
    }

    @DataBoundSetter
    public void setReviewStates(@NonNull String[] reviewStates) {
        this.reviewStates = Arrays.copyOf(reviewStates, reviewStates.length);
    }

    public void start(WorkflowJob project, boolean newInstance) {
        super.start((Item)project, newInstance);
        if (SCMHead.HeadByItem.findHead((Item)project) instanceof PullRequestSCMHead) {
            DescriptorImpl.jobs.computeIfAbsent(this.getKey(project), key -> new HashSet()).add(project);
        }
    }

    public void stop() {
        if (SCMHead.HeadByItem.findHead((Item)this.job) instanceof PullRequestSCMHead) {
            DescriptorImpl.jobs.getOrDefault(this.getKey((WorkflowJob)this.job), Collections.emptySet()).remove(this.job);
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String getKey(WorkflowJob project) {
        GitHubSCMSource scmSource = (GitHubSCMSource)SCMSource.SourceByItem.findSource((Item)project);
        PullRequestSCMHead scmHead = (PullRequestSCMHead)SCMHead.HeadByItem.findHead((Item)project);
        return String.format("%s/%s/%d", scmSource.getRepoOwner(), scmSource.getRepository(), scmHead.getNumber()).toLowerCase();
    }

    boolean matches(String reviewState) {
        if (this.reviewStates == null) {
            return true;
        }
        List<String> list = Arrays.asList(this.reviewStates);
        return list.contains(reviewState);
    }

    @Symbol(value={"pullRequestReview"})
    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        private static final transient Map<String, Set<WorkflowJob>> jobs = new ConcurrentHashMap<String, Set<WorkflowJob>>();

        public boolean isApplicable(Item item) {
            return false;
        }

        public Set<WorkflowJob> getJobs(String key) {
            return jobs.getOrDefault(key.toLowerCase(), Collections.emptySet());
        }
    }
}

