/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.trigger;

import hudson.model.Cause;
import java.util.Arrays;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class PullRequestReviewCause
extends Cause {
    private final String userLogin;
    private final String comment;
    private final String state;
    private final String[] reviewStates;

    public PullRequestReviewCause(String userLogin, String state, String comment, String[] reviewStates) {
        this.userLogin = userLogin;
        this.state = state;
        this.comment = comment;
        this.reviewStates = Arrays.copyOf(reviewStates, reviewStates.length);
    }

    @Whitelisted
    public String getUserLogin() {
        return this.userLogin;
    }

    @Whitelisted
    public String getComment() {
        return this.comment;
    }

    @Whitelisted
    public String getState() {
        return this.state;
    }

    @Whitelisted
    public String[] getReviewStates() {
        return Arrays.copyOf(this.reviewStates, this.reviewStates.length);
    }

    public String getShortDescription() {
        return String.format("%s reviewed: %s", this.userLogin, this.state);
    }
}

