/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.client;

import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.service.MilestoneService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedGitHubClient;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedMilestone;

public class ExtendedMilestoneService
extends MilestoneService {
    public ExtendedMilestoneService(ExtendedGitHubClient client) {
        super((GitHubClient)client);
    }

    public ExtendedGitHubClient getClient() {
        return (ExtendedGitHubClient)super.getClient();
    }

    public ExtendedMilestone getMilestone(IRepositoryIdProvider repository, int number) {
        return this.getMilestone(repository, Integer.toString(number));
    }

    public ExtendedMilestone getMilestone(IRepositoryIdProvider repository, String number) {
        String repoId = this.getId(repository);
        return this.getMilestone(repoId, number);
    }

    private ExtendedMilestone getMilestone(String id, String number) {
        if (number == null) {
            throw new IllegalArgumentException("Milestone cannot be null");
        }
        if (number.length() == 0) {
            throw new IllegalArgumentException("Milestone cannot be empty");
        }
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/milestones");
        uri.append('/').append(number);
        GitHubRequest request = this.createRequest();
        request.setUri(uri);
        request.setType(ExtendedMilestone.class);
        return (ExtendedMilestone)((Object)this.getClient().getUnchecked(request).getBody());
    }
}

