/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.client;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.client.PagedRequest;
import org.eclipse.egit.github.core.service.IssueService;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedGitHubClient;

public class ExtendedIssueService
extends IssueService {
    public ExtendedIssueService(ExtendedGitHubClient client) {
        super((GitHubClient)client);
    }

    public ExtendedGitHubClient getClient() {
        return (ExtendedGitHubClient)super.getClient();
    }

    public void lockIssue(IRepositoryIdProvider repository, int issueNumber) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/lock");
        this.getClient().put(uri.toString());
    }

    public void unlockIssue(IRepositoryIdProvider repository, int issueNumber) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/lock");
        this.getClient().delete(uri.toString());
    }

    public void addAssignees(IRepositoryIdProvider repository, int issueNumber, List<String> assignees) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/assignees");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(1, 1.0f);
        params.put("assignees", assignees);
        this.getClient().post(uri.toString(), params, (Type)((Object)Issue.class));
    }

    public void removeAssignees(IRepositoryIdProvider repository, int issueNumber, List<String> assignees) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/assignees");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(1, 1.0f);
        params.put("assignees", assignees);
        this.getClient().delete(uri.toString(), params);
    }

    public Issue setMilestone(IRepositoryIdProvider repository, int issueNumber, Integer milestoneNumber) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        HashMap<String, Integer> params = new HashMap<String, Integer>(1, 1.0f);
        params.put("milestone", milestoneNumber);
        return (Issue)this.getClient().patch(uri.toString(), params, (Type)((Object)Issue.class));
    }

    public void setAssignees(IRepositoryIdProvider repository, int issueNumber, List<String> assignees) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/assignees");
        HashMap<String, List<String>> params = new HashMap<String, List<String>>(1, 1.0f);
        params.put("assignees", assignees);
        this.getClient().put(uri.toString(), params, (Type)((Object)Issue.class));
    }

    public PageIterator<Label> getLabels(IRepositoryIdProvider repository, int issueNumber) {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/labels");
        PagedRequest request = this.createPagedRequest();
        request.setUri(uri);
        request.setType(new TypeToken<List<Label>>(){}.getType());
        return this.createPageIterator(request);
    }

    public List<Label> setLabels(IRepositoryIdProvider repository, int issueNumber, List<String> labels) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/labels");
        return (List)this.getClient().put(uri.toString(), labels, new TypeToken<List<Label>>(){}.getType());
    }

    public List<Label> addLabels(IRepositoryIdProvider repository, int issueNumber, List<String> labels) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/labels");
        return (List)this.getClient().post(uri.toString(), labels, new TypeToken<List<Label>>(){}.getType());
    }

    public List<Label> removeLabel(IRepositoryIdProvider repository, int issueNumber, String label) throws IOException {
        String repoId = this.getId(repository);
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(repoId);
        uri.append("/issues");
        uri.append('/').append(issueNumber);
        uri.append("/labels");
        uri.append('/');
        String encodedLabel = URLEncoder.encode(label, "UTF-8").replace("+", "%20").replace(".", "%2E");
        uri.append(encodedLabel);
        return (List)this.getClient().delete(uri.toString(), new TypeToken<List<Label>>(){}.getType(), null);
    }
}

