/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Date;
import java.util.Objects;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.jenkinsci.plugins.pipeline.github.GitHubHelper;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitComment;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitService;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class ReviewCommentGroovyObject
extends GroovyObjectSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String jobId;
    private final RepositoryId base;
    private ExtendedCommitComment commitComment;
    private transient ExtendedCommitService commitService;

    ReviewCommentGroovyObject(String jobId, RepositoryId base, ExtendedCommitComment commitComment, ExtendedCommitService commitService) {
        this.jobId = Objects.requireNonNull(jobId, "jobId cannot be null");
        this.base = Objects.requireNonNull(base, "base cannot be null");
        this.commitComment = Objects.requireNonNull(commitComment, "commitComment cannot be null");
        this.commitService = Objects.requireNonNull(commitService, "commitService cannot be null");
    }

    private ExtendedCommitService getCommitService() {
        if (this.commitService == null) {
            this.commitService = new ExtendedCommitService(GitHubHelper.getGitHubClient(GitHubHelper.getJob(this.jobId)));
        }
        return this.commitService;
    }

    @Whitelisted
    @Deprecated
    public Integer getLine() {
        return this.commitComment.getLine();
    }

    @Whitelisted
    public Integer getPosition() {
        return this.commitComment.getPosition();
    }

    @Whitelisted
    public Integer getOriginalPosition() {
        return this.commitComment.getOriginalPosition();
    }

    @Whitelisted
    public String getCommitId() {
        return this.commitComment.getCommitId();
    }

    @Whitelisted
    public String getOriginalCommitId() {
        return this.commitComment.getOriginalCommitId();
    }

    @Whitelisted
    public String getPath() {
        return this.commitComment.getPath();
    }

    @Whitelisted
    public String getDiffHunk() {
        return this.commitComment.getDiffHunk();
    }

    @Whitelisted
    public Date getCreatedAt() {
        return this.commitComment.getCreatedAt();
    }

    @Whitelisted
    public Date getUpdatedAt() {
        return this.commitComment.getUpdatedAt();
    }

    @Whitelisted
    public String getBody() {
        return this.commitComment.getBody();
    }

    @Whitelisted
    public long getId() {
        return this.commitComment.getId();
    }

    @Whitelisted
    public String getUrl() {
        return this.commitComment.getUrl();
    }

    @Whitelisted
    public String getUser() {
        return GitHubHelper.userToLogin(this.commitComment.getUser());
    }

    @Whitelisted
    public long getInReplyToId() {
        return this.commitComment.getInReplyToId();
    }

    @Whitelisted
    public String getPullRequestUrl() {
        return this.commitComment.getPullRequestUrl();
    }

    @Whitelisted
    public long getPullRequestReviewId() {
        return this.commitComment.getPullRequestReviewId();
    }

    @Whitelisted
    public void setBody(String body) {
        Objects.requireNonNull(body, "body cannot be null");
        ExtendedCommitComment edit = new ExtendedCommitComment();
        edit.setId(this.commitComment.getId());
        edit.setBody(body);
        try {
            this.commitComment = this.getCommitService().editComment2((IRepositoryIdProvider)this.base, edit);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public void delete() {
        try {
            this.getCommitService().deleteComment((IRepositoryIdProvider)this.base, this.commitComment.getId());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void replyTo(String body) {
        Objects.requireNonNull(body, "body is a required argument");
        try {
            this.getCommitService().replyToComment((IRepositoryIdProvider)this.base, this.commitComment.getCommitId(), (int)this.commitComment.getId(), body);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

