/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import groovy.lang.GroovyObjectSupport;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedMilestone;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class MilestoneGroovyObject
extends GroovyObjectSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final ExtendedMilestone milestone;

    MilestoneGroovyObject(String jobId, ExtendedMilestone milestone) {
        this.jobId = Objects.requireNonNull(jobId, "jobId cannot be null");
        this.milestone = Objects.requireNonNull(milestone, "milestone cannot be null");
    }

    @Whitelisted
    public Date getCreatedAt() {
        return this.milestone.getCreatedAt();
    }

    @Whitelisted
    public Date getDueOn() {
        return this.milestone.getDueOn();
    }

    @Whitelisted
    public int getClosedIssues() {
        return this.milestone.getClosedIssues();
    }

    @Whitelisted
    public int getNumber() {
        return this.milestone.getNumber();
    }

    @Whitelisted
    public int getOpenIssues() {
        return this.milestone.getOpenIssues();
    }

    @Whitelisted
    public String getDescription() {
        return this.milestone.getDescription();
    }

    @Whitelisted
    public String getState() {
        return this.milestone.getState();
    }

    @Whitelisted
    public String getTitle() {
        return this.milestone.getTitle();
    }

    @Whitelisted
    public String getUrl() {
        return this.milestone.getUrl();
    }

    @Whitelisted
    public String getCreator() {
        return this.milestone.getCreator().getLogin();
    }

    @Whitelisted
    public Date getUpdatedAt() {
        return this.milestone.getUpdatedAt();
    }

    @Whitelisted
    public Date getClosedAt() {
        return this.milestone.getClosedAt();
    }
}

